.TH LIFE 1 \" -*- nroff -*-
.SH NAME
life \- run and edit objects in Conway's Game of Life
.SH SYNOPSIS
.B life
[-v] [-t] [-g] [-s scale] [-l libdir] ... [-i initfile] ... [filename]
.SH DESCRIPTION
If you do not know what the Game of Life is, then see the appendix at the end.
Except in that appendix, the remainder of this document assumes that you
know the rules and terms of the game.
.PP
This program plays the Game of Life on a very large board using
sparse matrices.
The memory requirements depend on the total number of live cells of the
object, and not on their locality.
Therefore Life objects which cover a very large area can be manipulated.
The time needed to compute generations depends on the number of live cells,
not on the area covered by an object.
.PP
The program can run either under X11 with a view many hundreds of cells
wide and high using individual pixels,
or else on normal terminals which provide a view of about 24 by 80 cells
using normal characters.
.PP
This documentation is mostly aimed for use under X11.
For terminal use, terms such as 'window' need to be interpreted
loosely to make sense for the terminal screen.
.PP
Note that this program is designed for its editing and viewing capabilities,
not for its raw speed.
It contains commands to extract parts of objects, to manipulate multiple
objects, and to recombine them again.
To simply compute lots of generations quickly, use a program such as xlife.
.SH QUICK DEMO
Try the following demo to see how the program works.
This demo only shows a few of the available features.
.PP
Start the program by typing 'life'.
Notice that there is a text line at the top of the window,
and a cursor in the middle of the window.
.PP
Type the letters 'h', 'j', 'k', and 'l' to move the cursor around.
(Under X11, you can also use the arrow keys.)
.PP
Type the letter 't' to toggle the state of the current cell.
Use it and the movement commands to build up an object to run.
.PP
Type the letter 'G' to start running generations.
.PP
Type the letters 'H', 'J', 'K', and 'L' to shift the view of the object,
whether or not it is running.
.PP
Type the letter 'g' to stop the running of the object,
or if it is already stopped, to run it for one more generation.
.PP
If the object has grown beyond the visible area,
type 'S' to automatically scale the view to see the whole object.
.PP
Type the 's' command to turn off autoscaling,
and also to center the view around the current cursor position.
.PP
Stop the running of the object, position the cursor on a live cell which
is part of a large piece of the object, and type the sequence 'dd' to
delete that piece.
.PP
Move the cursor somewhere else and then type 'p' to reinsert the deleted
piece at the new location.
.PP
Type the sequence ';zero' and a return to clear the object.
Notice that this only works if generations are not being run.
.PP
Finally, type the sequence ';quit' and a return to leave the program.
.SH VIEWING OBJECTS
The window is divided up into two different areas.
The top area of the window contains a line of text
which is used for several purposes.
The remainder of the window is used for displaying of a Life object.
.PP
The text normally displayed on the top line is a status message which shows
information about the currently displayed Life object along with some
state of the program.
It is displayed unless a command line or error text is displayed.
While a command line is being entered, the text line shows the command
line as it is typed and is removed when the command line is completed.
If an error occurs, the error message is displayed in the text line
and remains until another key is typed.
.PP
The view of a Life object is a window into an very large Life universe which
has about 2^32 cells on a side.
There is a cursor visible which always represents the location of interest.
The view is shifted as necessary to always keep the cursor visible within
the window.
There are many commands which move the cursor, and these will implicitly
reposition the view when the cursor tries to move out of the view.
.PP
Besides the Life cells themselves, there are several other things that
can be visible in the window.
Some cells can be selected for some purpose, and the selected cells are
shown differently than the normal cells.
A grid can be added to help determine distances within the Life object.
Finally, some line segments making up a path to be acted on can be displayed.
.SH SCALING
When an object is large, then not all of it might be seen at once.
In this case, the view can be scaled up so that more of the object
can be seen at one time.
A scale factor of 1 to 1000 can be applied, which means that each
pixel (or character) on the screen represents a square of the given size.
Obviously, details of the object are lost when this is done,
but scaling is still useful for seeing the overall structure of a large
object and to position the cursor within the object.
.PP
Under X11, representing each cell by individual pixels makes
seeing or editing of objects difficult.
So the view can be scaled down so that each cell is represented by a
square number of pixels.
Negative scale factors specify the size of the square representing a cell.
If the scale factor is -2, then the cells run into each other.
If the scale factor is -3 or smaller, then blank lines separate each cell
so that the individual cells can be distinguished easily.
The default scale factor is -8.
.PP
When the output is to a terminal and the scale factor is set larger than one,
then each position containing live cells is marked with a number from 1 to 9,
or an asterisk.
A number is the actual count of live cells in the square,
while an asterisk means there are 10 or more live cells in the square.
Negative scale factors are not allowed for terminals.
.SH CHARACTER MODE COMMANDS
There are two different kinds of commands to the life program.
These are the character mode commands and the line mode commands.
.PP
Character mode commands are short sequences of characters which are
self-terminating (in the same manner as the commands to the vi editor).
They do not echo as they are being entered.
Until the character sequence is complete,
it can be edited using the normal erase and kill characters.
When the sequence is complete, then it is immediately executed.
.PP
Character mode commands can be preceded by zero, one, or two numeric arguments.
These arguments are generally used as a count of how many times the command
is to be executed.
Missing arguments are defaulted to 1
(with the exceptions noted in the tables while appear later).
If two arguments are specified, then they are separated by a comma.
So a character mode command can take one of the following forms:
.sp
.nf
         <cmd>   Both arguments defaulted.
     <a1><cmd>   One argument given, second is defaulted.
<a1>,<a2><cmd>   Both arguments given.
.fi
.PP
A numeric argument is usually an explicit number.
But it can also be an numeric expression enclosed within parenthesis,
or else one of a set of special values which are described later.
For example, the command '(2+3)L' is the same as '5L'.
.PP
Calculation of generations of an object can still be run while a character
mode command is being entered.
This allows the repositioning of the view and the changing of scaling factors
without having to stop calculations for an object.
However, many character mode commands (such as ones which change the object)
are illegal while the object is running.
.SH LINE MODE COMMANDS
Line mode commands begin with either a colon or a semi-colon character,
and are terminated by an end of line character.
These commands are full words which can be abbreviated,
followed by space separated arguments.
Line mode commands are echoed at the top of the screen as they are being
entered so that editing of them is easy.
.PP
If generations are currently being run at the time a line mode command is
started, the calculations will be suspended until the command is completed.
.PP
Use the ';help' command to list all of the line mode commands.
Some commands are used so often that they can be abbreviated to single
characters even when ambiguous.
These are marked with an asterisk in the listing.
.PP
A command you should know before starting the Life program is ';quit'
which quits from the program.
It can be abbreviated to just ';q'.
.SH MOVEMENT AND CHANGING OF THE VIEW
Most commands (and the area being viewed)
are based on the current cursor location.
To change the viewing region, or to point at a location in the
object that you wish to modify,
you must move the cursor around in the object.
To do this, you use some character mode commands.
The directions for movement are based on vi, so that for example, 'h'
moves left, 'j' moves down, 'y' moves to the upper left, and so on.
You can also use diagonal movement commands which are 'y', 'u', 'b', and 'n'.
.PP
These commands are multiplied by the scale factor (if positive),
so that you can move about in large objects easily.
In addition, they accept an optional preceding numeric argument
which multiplies their movement by the given amount.
For example, with a scale factor of 2 the command '5k' moves up by 10 cells.
.PP
The movement commands when capitalized perform a shift of both the cursor
and the viewing region together by 1/5 of the screen size.
This is useful to shift the view to see an object on the edge better.
When shifting diagonally, movement is always at 45 degree angles,
independent of the relative sizes of the width and height of the screen.
.PP
The 's' command with an argument sets the scale factor for the current object
being viewed as desired, and centers the view on the current position of the
cursor.
Without an argument, 's' simply centers the view without changing the
scale factor.
.PP
The 'S' command does auto-scaling, which selects the smallest positive scale
factor which will enabling viewing of the whole object.
As the object grows, the scaling factor will be increased automatically to
keep the complete object in view.
Using 's' will disable auto-scaling again.
.SH EDITING OF AN OBJECT
The simplest commands for changing an object are 'o', 'x', and 't'.
The 'o' command creates a live cell and moves the cursor to the right.
The 'x' command creates a dead cell and moves the cursor to the right.
Both of these commands can accept a numeric argument which replicates
their action by the given amount.
As an example, the command string '25o' creates a row of 25 live cells.
.PP
The 't' command toggles the current cell from dead to alive (or from alive
to dead) without moving the cursor, and is usually the most convenient
command to use when editing an object by hand.
.PP
The ';mode' command sets a mode in which some of the movement commands
described earlier automatically insert or delete cells.
This makes it easy to create lines of cells in any direction.
The argument is either 'insert', 'delete', or 'move', which may
be abbreviated.
For example, if the mode is insert, then the command '20j' will create a
row of 20 cells downwards.
.SH RUNNING GENERATIONS
To compute generations, use the 'g' or 'G' commands.
The 'g' command computes a single generation of the current object,
or as many more generations as is specified in its preceding argument.
The 'G' command simply means run for an infinite number of generations.
If the object dies or becomes stable, computations automatically stop.
(However, loops of period 2 or greater are not detected.)
.PP
While generations are running, and you supply an argument to the 'g' command,
then the specified number of generations gets added to the ones already
being computed.
On the other hand, if generations are running, and you use the 'g' command
with NO arguments, then computations are stopped immediately.
.PP
While generations are being computed, you can use the movement and scaling
commands to wander around the object.
But attempts to change the object while it is running will be rejected.
If you wish to wait until the indicated computations are complete before
the next command is executed, use the ';wait' command (this is most useful
inside of a command macro or loop).
.PP
Normally each generation will be displayed as it is computed.
To speed up the computations when you don't want to see every generation,
use the ';frequency' command to set how often the screen is updated.
.SH USE OF MULTIPLE OBJECTS
This program can simultaneously handle more than one Life object.
Each object is distinct and has its own name.
The initial object when you start the program is called "main".
You move between objects to select the one that you wish to edit or display.
.PP
The ';edit' command switches between objects (defaulting to the the
previously edited object if no name is given).
If the object does not yet exist, then a new object with that name is created.
The special name of "." means the currently edited object, and the special
name of ".." means the last object previously edited.
The ';objects' command will display data about all objects.
.PP
Cells can be copied or moved between objects.
This allows you to make backups of an object, or split up and edit the
parts of a single object.
The ';copy' command copies the current object to another object.
The ';insert' command inserts another object into the current object.
This is done in such as way that the two object's cursor locations match.
.PP
When a new object is created or an old object is zeroed, its scaling factor
and its display frequency are initialized to useful default values.
You can use the ';default' command to change these default values.
Use ';default scale' to change the default scaling factor,
and use ';default frequency' to change the default display frequency.
These parameter names can be abbreviated.
.SH GRIDS
When you are trying to count the number of cells between two parts of an
object, then the ';grid' and ';nogrid' commands are useful to turn a grid
on and off.
.PP
For X11 output, the grid is drawn using small dots in the corners
of all the visible cells, whether alive or dead.
Every tenth row and column in the grid is drawn in a different color so
that you can count distances of multiples of 10 easily.
The differently marked rows and columns are determined by the
absolute coordinates of the cells
so that their alignment with respect to the cells does not change
even when the viewed area is changed.
The grid will not be displayed unless the scale factor is -3 or less,
otherwise it would be difficult to distinguish the grid from the cells.
.PP
For terminal output, the ';grid' command changes the display of dead cells
from blanks to another character specified by the command.
If no character is specified, then periods are used.
There is no special marking of every tenth row or column.
.SH MARKS
A very useful feature is the use of marks.
You can select any group of cells of an object, and handle them specially,
leaving the rest of the cells unchanged.
For example, you can save the marked cells as a different object,
or can move them around, or can delete them.
Marked cells appear differently in the display so that you can recognize
which cells are marked.
.PP
Each time you mark some cells, the new cells get added to the set of cells
which were already marked.
This lets you build up the set of marked cells using multiple marking
commands, and then act on the final marked set.
When you want to unmark all the cells to begin a new set,
use the ';unmark' command.
.PP
Marks are set using the 'm' command, followed by a set specifier letter.
For example, the command 'mv' marks all of the cells which are currently
visible in the window.
The full list of set specifiers is described in detail later.
.SH PATHS
A very advanced editing feature is the use of paths.
A path is composed of one or more closed loops of line segments.
The line segments join the centers of the cells, NOT the edges or corners
of the cells.
Each closed loop encloses an area containing a number of cells.
The live cells within those areas can be operated on as a unit,
with the usual operations being deletion or marking.
Cells exactly on the path are also considered to be within the area.
The boundary of a path can be arbitrarily complex.
The only limits on a path are the memory used to store it
and the speed of processing it.
.PP
If two loops overlap each other, or if one loop crosses itself,
then the definition of what is inside the path becomes complicated.
The basic rule is that a cell is inside if and only if a typical line segment
drawn from that cell out to infinity crosses the path an odd number of times.
This means that for two loops which have no points in common,
then both loops enclose an area to be acted on.
But if one loop is enclosed by another one, then the inner loop excludes its
own area from being acted on.
.PP
To begin defining a path, use the 'a' command.
It adds a point to the path at the current cursor location, and draws a line
segment from that point back to the previous ending point of the path (if any).
The path being drawn is shown in green under X11.
.PP
You use the 'A' command to close off the current loop of the path
so that you can begin to make another disjoint loop.
This draws the final line segment from the first point of the loop to the
last point of the loop.
The 'A' command has no effect if the path is already closed so that
multiple 'A' commands in a row are harmless.
.PP
Notice that the 'A' command is not required before using a path,
since there is always an implied closure of a loop even if the implied
last segment isn't visible on the screen.
.PP
You can use the ';shorten' command to remove one or more of the final
segments of the currently defined path.
This is useful if you have made an error in defining the path.
The command accepts an optional numeric argument giving the number of
line segments to remove from the path.
To remove the path completely, use the ';clearpath' command.
.PP
The defined path is used by using the letter 'p' in any of the commands
which act on sets of cells, as described in the following section.
As a side effect of using the path, it is cleared to enable a new path
to be conveniently started.
.PP
The ';restorepath' command will restore a path that has been explicitly
or implicitly cleared so that you can use it again.
Starting a new path prevents the restoration of the previous path.
.PP
Paths can still be used when running on a terminal, but the segments
making up the paths are not visible on the screen.
.SH ACTING ON SETS OF CELLS
A few commands act on a set of cells specified as part of the command.
There many possible sets that can be specified.
Many of these sets are determined based on the cursor's current location.
.PP
Here are the commands which act on a specified set of cells:
.sp
.nf
d<set>     delete cells
fr<set>    flip cells around the cursor's row
fc<set>    flip cells around the cursor's column
r<set>     rotate cells 90 degrees clockwise around the cursor
m<set>     mark cells
.fi
.PP
The '<set>' in the above commands are one of the following letters:
.sp
.nf
h     cells to left of cursor
l     cells to right of cursor
k     cells above cursor
j     cells below cursor
b     cells below and left of cursor
n     cells below and right of cursor
u     cells above and right of cursor
y     cells above and left of cursor
c     cell at location of cursor
o     cells in the king-wise connected object at the cursor
e     cells in the king-wise extended connected object at the cursor
p     cells inside or on the currently drawn path
r<ch> cells in rectangle determined by the cursor and another location
      (here <ch> is either '@' for the origin or a 'where' variable)
v     cells visible in window
i     cells invisible in window (outside)
m     cells which are marked
a     all cells
.fi
.PP
Here are some examples of command used with sets.
The command 'dk' deletes all of the cells which are on or above
the current row.
The command 'fra' flips the whole object around the current row.
The command 'mp' marks all of the cells inside the current path,
.PP
As an special case, repetition of the initial command letter specifies
a set which is the same as the 'o' set specifier,
which means all of the cells which are connected to the cell which is
at the cursor's location.
As examples, 'dd' is the same as 'do', and 'frf' is the same as 'fro'.
.SH THE ORIGIN
A few commands make use of a location within an object called the origin.
The origin is a location that is remembered in an object,
independent of the current cursor location.
You can think of it as the location whose coordinates are (0,0).
When an object is created or zeroed, the cursor is positioned at the origin.
.PP
Several commands act relative to the position of the origin.
The '\\n' command moves to the next row and back to the column of the origin.
The '\\t' command moves to the next column which is a multiple of eight
cells away from the origin's column.
The 'c' command moves to a specified row and column offset from the origin's
position.
This lets you specify the cells of an object given their coordinate values.
Finally, the origin is used by the 'r' set selector character,
and determines the far corner of a rectangular region to be acted on.
.PP
The origin does not have to remain at a fixed location in an object.
The '@' command sets the origin to the current cursor location, so you
can move it as required.
.SH WHERE LOCATIONS
Besides the cursor and the origin, there are 26 other saved locations
within an object which you can refer to.
These are the 'where' locations, named for the lower case letters.
.PP
To remember a location in an object, use the 'W' command followed by a
lower case letter.
This associates the current coordinates of the cursor with the specified
letter.
.PP
To return back to the remembered location,
use the 'w' command followed by the same letter to move the cursor
back to the remembered location.
If any arguments are given, then the cursor is offset by those values.
.PP
The 'where' locations are preserved across the running of generations
so that you can still position back to areas of interest.
.SH LOOPS AND MACROS
Command loops and macros can be defined using the '<' and '>' commands.
If a numeric argument is specified before the '<', then a loop is being defined.
If no argument is given, then a macro is being defined.
.PP
While defining a macro or loop, the commands you type are executed normally
so that you can see how the definition will execute.
This is useful when you define a macro to create an object,
since you can easily see how to create the object.
Loops and macros can contain both line mode and character mode commands.
While you are defining a loop or macro, the status line will indicate
this and give the current depth of loop or macro nesting.
.PP
If a loop is being defined, the loop is executed the number of times
specified by the argument to the '<'.
If two arguments are specified, the loop runs from the first to the second
argument (backwards if the second argument is less than the first argument).
The value of the loop counter is available in the loop itself by using '%'
as you would a number.
.PP
As an example of a loop, the command string '3,7<%o.>' inserts five strings
of cells spaced apart by one cell, where the first string contains three
cells, and the last string contains seven cells.
.PP
When nesting loops, supplying an argument to '%' can obtain the loop
counter values for the outside loops while in the inner loop.
Thus, '2%' obtains the loop value for the next-to-innermost loop level.
.PP
When defining a macro, the next character after the '<' is the macro name to
define (which must be a lower case letter, upper case letter, or a digit).
All of the commands between the '<' and the '>' (except for the macro
name character) are saved.
.PP
Once a macro has been defined, it is used by typing the ESCAPE character
followed by the macro letter.
As an example, the command string '<gththtuktntj>' defines a macro
named 'g' which causes a glider to be inserted at the current cursor
position every time you type '<ESC>g'.
.PP
The macros for the digits 1 to 9 are automatically bound to the function
keys under X11.
For example, hitting the F5 key will execute macro 5.
.PP
While defining a loop or macro, you can request user intervention by using
the ';ttyinput' command.
This will suspend the execution of the loop or macro and notify the user
that input is desired by displaying 'tty-input' in the status line.
The user can then execute any commands of his choice.
When he is ready to proceed, he uses the ';endinput' (or a control-D)
command to continue execution where it had paused.
Different commands can be given by the user each time the loop or macro
asks for terminal input.
If the command ;ttyinput -c' is used, terminal commands will only be
asked for if there is any terminal input available to be read.
.PP
Normally, the screen is not updated while a macro or loop is executing.
Thus a complicated command sequence can be executed without letting the
user see what is occurring until it is finished.
However, if you wish to update the screen in the middle of execution,
then use the ';update' command.
Commands given by the user automatically do an update whenever
no more user input is available.
.PP
The ';dump' command writes out the definitions of all macros and button
assignments so that you can read them back in later.
.SH USING THE MOUSE
When running under X11, the mouse can be used to move the
cursor to any position within the view,
and can also optionally execute a command macro of your choice.
.PP
If no command macros are assigned to the mouse buttons, then pressing any
button simply moves the cursor to the specified cell and does nothing else.
Mouse activity can be reasonably used within a macro or loop definition
since mouse events are always translated to the appropriate 'l' and 'j'
relative movement commands and executed in that form.
.PP
The ';assign' command assigns a mouse button number to a
command macro letter.
The normal three mouse buttons are numbered 1 to 3.
Using a modifier key (such as SHIFT) with a button adds three more
possibilities numbered 4 to 6.
.PP
When the mouse is positioned and a button which has an assignment is pressed,
then the cursor is moved to the selected cell as normal and then the assigned
command macro is executed.
With the proper command macros being defined and assigned, this lets you use
the mouse buttons for many useful operations like toggling cells,
deleting pieces of objects, or repositioning the view.
.SH VARIABLES
The program provides numeric variables which you can use to control your
commands.
Variables are used as numeric arguments to commands.
Variables come in two kinds.
These are the user-defined single character variables,
and a set of predefined multi-character variables.
.PP
There are 52 single-character variables, whose names are the lower and upper
case letters.
All of their values are initially zero.
When used for a character mode command (and without the use of parenthesis),
variable names must be preceded by a dollar sign to distinguish
them from commands.
For example, the command '$mo' inserts as many live cells in a row as is
contained in the value of variable 'm'.
.PP
When used within an expression for a line mode command, or within a set of
parenthesis in a character mode command, the dollar sign can be dropped
since the parser knows to expect a variable name in these cases.
For example, the command ';type m' will display the value of variable 'm'.
Similarly, the command '(m*2)o' will set a number of live cells equal to
twice the value of variable 'm'.
.PP
Single character variables are set by using the ';set' command,
which takes a variable name followed by an expression.
For example, the value of variable 'e' can be tripled by using the
command ';set e e * 3'.
As a shortcut for a common operation, the '+c' character mode command
increments variable c.
(A numeric argument can be given to specify an increment
value other than than 1.)
.PP
One common use of variables is inside a macro in order to execute a command
string over and over again with only small differences each time
(such as to vary the placement of two objects with respect to each other).
As an example of this, the command '<q$ao3+a>' will define a macro
called 'q' which will insert a number of live cells in a row
(as determined by variable 'a'),
and the number of cells inserted increases by 3 for each use of the macro.
.PP
The other kind of variables are the multi-character variables.
These are a fixed set of names, and their values represent specific
things which are not directly modifiable.
These things are values associated with the current object.
For example, the 'cx' variable returns the absolute x coordinate of
the current cursor position, and 'oy' returns the absolute y coordinate
of the origin.
The set of variables names 'w<ch>x' and 'w<ch>y' where ch is a lower case
letter represent the x and y coordinates of the 'where' variables.
.PP
You can see the complete set of variables by using the ';variables' command.
The variables at the top of the display are always listed no matter
what their value is.
But the rest of the variables are only listed if their values are nonzero.
This applies to both the single character variables and the 'where' variables.
.PP
The ';type' command is useful to perform calculations on the relative
positions of cells.
For example, to find the number of columns between two positions which are far
apart, you can move the cursor to the first position, use the 'Wa' command to
set the 'where' variable 'a' to that position, and finally move the cursor to
the second position.
Then the command ';type cx - wax' will display the number of columns
separating the two positions.
.PP
Since the parser must be able to distinguish multi-character variable names
from command letters or single-letter variable names, you cannot use them in
character mode commands without surrounding them with a pair of parenthesis.
As an example of multi-character variables used as an argument, the command
string '((vmaxx-vminx)/2)h' shifts the cursor to the left by an amount
equal to half of the screen width.
.SH FILE HANDLING
The ';read filename' command reads in a command file, or else a description
of a Life object in either a subset of the xlife format or in a rle format.
The read command automatically distinguishes these three different formats
depending on the first character of the file.
.PP
Command files can execute any of the life program's commands, but normally
contain a picture of an object to be inserted.
Thus for small objects, you can simply create a picture of an object in
an editor, and then the object can be read in by the life program.
Here spaces or periods represent OFF cells, and 'O, 'o', or '*' characters
represent ON cells.
Lines beginning with '!' are ignored, so that you can comment your objects.
Command files must begin with a '!' character.
.PP
The xlife format is a list of coordinates of live cells, which are generated
by the well-known xlife program.
(Indirect files are not supported.)
Files which begin with a '#' character are assumed to be in xlife format.
.PP
The rle format is a "run-length encoded" format which is a very good compact
storage format for objects.
This is the smallest storage format for large objects, but has the
disadvantage that there is no other information stored in the file
about an object other than its actual cells.
Files which begin with a 'x' character are assumed to be in rle format.
.PP
When reading an input file, the program looks for six different file names in
sequence.
It starts by looking for the file name as given.
Then it looks for the name with an '.l' extension appended.
Then, if the -l option had been used to specify a one or more personal
libraries, then it looks in the specified directories for the file,
and then for the file with the '.l' extension.
Finally, it looks in /usr/games/lib/life for the file, and then for the file
with the '.l' extension.
Thus there is a standard library of interesting Life objects,
and you can create your own Life libraries.
.PP
The ';list' command will display a list of those file with '.l' extensions
that can be read in.
If given an argument, then only those path names which contain the
specified string will be listed.
For the library directories, ';list' will show the Life files within
several levels of subdirectories.
For example, ';list gun/' will list all the Life files within a directory
called 'gun'.
The '-d' option can be given to the ';list' command to show the files
with '.l' extensions in a specified directory.
If no directory is given, then '.' is used.

.PP
The command ';write filename' is used to save the current object to a file.
The file can be written in any of the pictorial, xlife, or rle formats.
The default format is rle.
You can specify the desired format using one of the -picture, -xlife,
or -rle options within the write command.
(These options can also be abbreviated to single letters.)
For example, ';write -x it.l' will write the current object to 'it.l'
in xlife format.
.PP
When writing an object to a file in the pictorial format, what is
written is a sequence of commands which regenerates the object using the
normal commands of the program.
The choice of commands is such that for small objects,
the commands look like a picture of the object.
Thus, the object is written using the commands '.' (to move right), 'o'
(to insert cells), and '\\n' (to move to the next line).
(Periods are used instead of spaces so that you can count the spaces
between live cells easily.)
When writing out an object, if it is very wide or long, the output will
contain repeat counts as necessary in order to compress the resulting file.
.SH ALTERNATE RULES
The rules of Life can be changed to some degree.
This allows you to explore alternative Life universes.
You can specify how many live cells are required for a cell to be born,
or to stay alive.
However, you cannot change the neighborhood used for counting live cells
(the program always counts all of the eight neighboring cells).
.PP
To change the cells needed for birth or death, use the ';rules <born>,<live>'
line mode command.
The <born> string lists those counts of neighbors which are required for
a new cell to be born.
The <live> string lists those counts of neighbors which are required for an
existing cell to stay alive.
The standard rules are thus described by the command ';rules 3,23'.
.SH OTHER COMMANDS
Here are some of the remaining useful line mode commands.
The ';zero' command clears all cells of an object and
resets the scaling factor and cursor position.
The ';copymarked name' and ';movemarked name' commands copy or move
marked cells to another object.
The ';advance' command takes the marked object, removes it, runs the Life
rules for the specified number of generations, then reinserts the result
back into the current object, marking it.
.PP
Finally, the ';undo' command will undo the most recent change to the
current object.
This can undo deletions, insertions, and running of generations,
among other things.
But you get only one level of backup.
(A related backup feature is the 'p' command, which will reinsert
the last deleted object to the current cursor location.)
.SH INTERRUPTS
While the program is doing something which can take a long time, such as
computing generations, defining or executing a macro or loop, or writing
out a large Life object, you can type the interrupt key and that action
will be aborted at a convenient point and you will be returned to the top
command level.
.SH CHARACTER MODE COMMAND SUMMARY
The following table lists all the character mode commands, arranged in
useful categories.
These can be preceeded by one or two numeric arguments.
.PP
.nf
--- MOVEMENT COMMANDS ---

SPACE   move right <arg1> cells
.       move right <arg1> cells
l       move right <arg1> cells
h       move left <arg1> cells
l       move right <arg1> cells
k       move up <arg1> cells
j       move down <arg1> cells
y       move upper left <arg1> cells
u       move upper right <arg1> cells
b       move lower left <arg1> cells
n       move lower right <arg1> cells
LF      move to next row and to the column of the origin
TAB     move to next multiple of 8 from the origin column
@       remember current location as the origin
c       move to location <arg1>, <arg2> relative to the origin
W<ch>   remember current location in where variable <ch> (a-z)
w<ch>   move to location <arg1>, <arg2> relative to where
        variable <ch> (a-z)
/       move cursor to the next piece of the object

--- SCREEN COMMANDS ---

s       set viewing scale to <arg1> and center view
        (default current scale)
S       turn on auto-scaling and center view
H       shift view left by width/5
L       shift view right by width/5
K       shift view up by height/5
J       shift view down by height/5
Y       shift view left and up
U       shift view right and up
B       shift view left and down
N       shift view right and down
FF      refresh the screen

--- SINGLE CELL COMMANDS --

t       toggle cell at current location
o       insert <arg1> cells and move cursor right
O       insert <arg1> cells and move cursor right
*       insert <arg1> cells and move cursor right
x       kill <arg1> cells and move cursor right

--- MULTIPLE CELL COMMANDS ---

d<set>  delete cells described by <set>
fr<set> flip cells around current row as described by <set>
fc<set> flip cells around current column as described by <set>
r<set>  rotate cells 90 degrees clockwise as described by <set>
m<set>  mark cells as described by <set>
p       place last deleted object at current location

--- LOOP, VARIABLE, AND MACRO COMMANDS ---

<       begin loop which executes from <arg1> to <arg2> times
        (if <arg1> given)
<<ch>   begin definition of macro named <ch>
        (if <arg1> not given)
>       end loop or macro definition
ESC<ch> execute a macro command named <ch>
+<ch>   increment the value of the single-character variable
        <ch> by arg1

--- MISCELLANEOUS COMMANDS ---

g       compute <arg1> generations (or stop if running)
G       compute infinite generations
a       Add line segment to current path
A       Close current path
z       set generation number to <arg1> (default zero)
!       ignore characters until end of line
#       ignore character until end of line
;<line> execute a line mode command
:<line> execute a line mode command
.fi
.PP
Arguments specified above as <arg1> and <arg2> can be any of the following:
.PP
.nf
<var>   value of variable <var>, where <var> is a lower
        or upper case letter
(expr)  an arithmetic expression containing constants,
        variables, or operators
%       current loop counter value
<num>   explicit numeric value
.fi
.SH LINE MODE COMMAND SUMMARY
.PP
The following lists all of the line mode commands.
Each of these commands is started with a colon or semi-colon character,
and terminated with a new line character.
Words inside of parenthesis are noise words which just help explain the
command syntax, and are not actually part of the command.
This list can be obtained using the ';help' command.
.PP
.nf
advance (marked cells) expr (gens)
assign (button) num (to macro) ch
clearpath (from current object)
copy (current object to) obj
copymarked (cells to) obj
destroy (object named) obj
default param (to) expr
dump (initialization data to) file
edit (object named) obj
endinputlevel
frequency (of typeout is) expr
grid (character is) char
help
insert (object from) obj
invert (marks for all cells)
list (readable *.l files)
mode (for movement)
move (current object to) obj
movemarked (cells to) obj
nogrid
objects (are listed)
quit (program)
read (commands from) file
rename (current object to) obj
restorepath (to current object)
rule (for life are) born,live
set (variable) name (to) expr
shortenpath (from current object)
ttyinput
type (value of expression) expr
undo (last change)
unmark (all cells)
update (view to be current)
variables (are listed)
wait (for computations)
write (current object to) file
zero (current object)
.fi
.PP
In the above, expr is an arithmetic expression, and obj is an object name.
.SH OPTIONS
The program accepts options both from the command line and from the
LIFEOPTS environment variable.
If defined, the LIFEOPTS environment variable contains a list of options
as used on the command line.
The life program processes these options first, then processes the options
given on the command line.
If conflicting options are found, then the last ones specified are effective.
.PP
Here are the possible options when starting the life program.
.sp
.nf
-t             Use terminal output
-g             Use graphics output (X11)
-s <value>     Initialize the default scale to the given value
-l <libdir>    Set another personal library directory
-i <initfile>  Reads another file for setting macros and buttons
-v             Display the version number of the program and exit
<filename>     An initial object to be viewed
.fi
.PP
The -t and -g options specify the output device for the Life program.
Using -t uses the current terminal for output using curses.
Using -g uses X11, and a new full-screen sized window is opened for output.
If neither option is used, then graphics is assumed.
Almost all commands work identically between the two different
modes of operation.
The main differences are simply the differing resolutions of the displays
and the optional use of a mouse.
.PP
The -s option specifies a scale factor to be used by default for displaying
Life objects.
This default scale factor can be changed during execution of the program.
.PP
The -l option specifies an additional library directory to be searched
when Life objects are read in.
This directory is in addition to the current directory and the system
library directory /usr/games/lib/life.
This option may be used up to 10 times to specify a number of
library directories.
.PP
The -i option specifies the filename of an initialization file which
contains commands to configure macros and button assignments.
But the file can actually execute any commands and so could automatically
load some Life objects, for example.
The only restriction is that the initially displayed object is always
cleared after this file is read.
This option may be used up to 10 times to specify a number of initialization
files.
.PP
A filename without any preceeding option character is a Life object to be
read in and initially displayed.
If no filename is given, then the initial object is empty.
Only one filename can be specified.
.SH APPENDIX - THE RULES OF LIFE
This is a short introduction to Conway's Game of Life.
.PP
Life is played on an infinitely large board divided into squares.
Each square is called a cell.
Each cell can be either dead or alive.
Dead cells are seen as blanks, whereas live cells are seen as non-blanks.
You begin to play by choosing some arbitrary set of live and dead cells.
This configuration is called generation 0.
.PP
There is a set of rules which transforms this set of cells into another
set of cells, called generation 1.
These same rules are then reapplied to generation 1 to produce generation 2.
This process continues indefinitely.
.PP
The 'purpose' of the game is to find starting patterns such that 'interesting
things' result.
.PP
The rules which are applied are as follows.
Take any cell of a generation, and call it the current cell.
Consider the eight cells immediately adjacent to the current cell.
Count the number of these eight cells which are alive.
If the current cell is dead and the count is 3, then the current cell changes
to a live cell in the next generation.
If the current cell is alive and the count is NOT 2 or 3,
then the current cell changes to a dead cell in the next generation.
Otherwise the cell remains unchanged in the next generation.
This rule is applied to every cell of a generation SIMULTANEOUSLY.
Thus to rephrase, 3 live neighbors causes a new cell to be born,
whereas 2 or 3 live neighbors keeps a cell alive.
.PP
To see how these rules work in practice, run the program and start with some
number of live cells in some arrangement, and watch the generations change.
If you can predict what the changes will be, then you understand the rules.
.PP
The following are some objects to try, along with some descriptive names.
Warning: the last example gets complicated!
.nf
     O          O                  O             O          OO
     O         OO       OO         OO             O          OO
     O         O         O         O            OOO          O
  blinker   beehive   block   traffic lights   glider   r-pentomino
.fi
.SH AUTHOR
David I. Bell
