#ifndef _PLAYER_H
#define _PLAYER_H

#include "list.h"

class MsgQ;
class Unit;

enum { DESPOT, MONARCH, REPUBLIC, DEMOCRACY };

class City;

class Player
{
public:
  Player(char *Name, int Id);
  ~Player();

  char *name;
  char color1Str[40], color2Str[40]; // for fast color switching
  int id;
  List<ulong> citys;
  List<ulong> units;

  long cityPic; // compiled city pic

  int govt; // government type
  int tax;

  int money;

  int scienceAcc;
  int needScience;

  char *researching;

  List<charp> discovered;
  List<charp> canDiscover;
  List<charp> canBuild;

  List<charp> wonders;

  int templeEffect, cathedralEffect;

  List<charp> messages; // any messages we wan't to show in city turn

  // create the first unit and start up the player, will also send
  // out the info for this unit to all other players
  void Setup();

  // send all the moves we made in this turn
  void SendMoves(MsgQ *);

  // get all moves a remote player made
  void ShowMoves(MsgQ *, MsgQ *outQ);

  void InitMoveTurn();
  void MoveTurnMesg(MsgQ *);
  void MoveTurnKey(int event, int x, int y, char *data);

  void InitCityTurn();
  void CityTurnMesg(MsgQ *);
  void CityTurnKey(int event, int x, int y, char *data);

  void UpdateCities();

  long CompilePic(char **pic);

  void WonderEffect(City *city);
  int HasWonder(char *name);
  void DeleteWonder(char *name);

  // saves everything to save file
  void Save();

  void Restore(); // restore from save file

private:

  enum { NORMAL, IN_SELECT };
  enum { TAX_RATE, CITY_BUILDING };

  int state, selecting;
  int initiatedSave; // if save initiated

  MsgQ *unDispQ; // undisplayed moves
  int doneMoving; // true if he's told us he's done moving
  int acks_left; // number of acks remaining

  Unit *currUnit; // currently selected unit

  City *FindCityWithMsg();
};

typedef Player *PlayerP;

#endif
