/* C++ wrapper for assembler block copy routines */

#ifndef SPRITE_H
#define SPRITE_H

#include "btypes.h"

#include <SLList.h>
#include "animation.h"
#include "screen.h"

class
Sprite : public Animation, public Screen
{
private:
	void copy(const Sprite& s);
protected:
	byte *backmem, *maskmem, *blockmem;

	static SLList<Sprite*> vlist;
	static SLList<Sprite*> appearlist;
	static SLList<Sprite*> disappearlist;
	
        uint32 width,height,ByteLength;
	int xp,yp,oldxp,oldyp;
	int deltax,deltay;		/* used to show size of move */
	bool visibleflag;

	void MakeMask(byte maskcolour=0);
	void Transpaste( void );
	void CutBack( void );
public:
	Sprite();
	Sprite(const Sprite& s);
	~Sprite();
	Sprite& operator=(const Sprite& s);

	void gifLoadAndCut(char *filename, int slot);
	void Cut(uint32 x1, uint32 y1, uint32 xw, uint32 yw, int slot);
	void Paste(uint32 x1, uint32 y1);
	void Recut(uint32 x1, uint32 y2);
	void Update(){ Update(xp,yp); }
	void Update( int x1, int y1);
	void UpdateAll(void);
	void ReplaceAll(void);
	void PasteAll(void);
	void getAll(void);
	void hideAll(void);
	void move( int x1, int y1){ xp=xp+x1;yp=yp+y1;}
	void move( void){ xp=xp+deltax;yp=yp+deltay;}
	void getBack(uint32 x1, uint32 y1);
	void getBack(void){ getBack(xp,yp); }
	void fixBack( void );
	bool collide(const Sprite& s);
	void appear(void);
	void disappear(void);

	inline int getXp(void) const { return xp; }
	inline int getYp(void) const { return yp; }
	inline int getDeltaX(void) const { return deltax;}
	inline int getDeltaY(void) const { return deltay;}
	inline bool getVisible(void) const { return visibleflag;}
        inline int getHeight(void) const { return height;}
        inline int getWidth(void) const { return width;}

	void setSlot( int slot);
	void setVisible( bool v);
	inline void setDelta( int x1, int y1) { deltax=x1; deltay=y1;}
	inline void setPos( int x1, int y1) { xp=x1; yp=y1;}
};

#endif
