#ifndef SCREEN_H
#define SCREEN_H

/* Memberwise initialisation and copying should be fine */

typedef unsigned char pixel;

class
Screen
{
private:
	static pixel *gmem;
	static int scrwidth, scrheight;
	void copy (const Screen& s); 
public:
	Screen();
	Screen(const Screen& s);
	Screen& operator=(const Screen& s);
	inline int getScreenWidth(void) const { return scrwidth; };
	inline int getScreenHeight(void) const { return scrheight; };
	inline pixel* getGraphMem( void) const { return gmem; }

	inline void setScreenWidth(int w){ scrwidth=w;}
	inline void setScreenHeight(int h){ scrheight=h;}

	inline void setGraphMem( void *gptr) { gmem=(pixel *)gptr; }
};

#endif
