#include "screen.h"
#include "sprite.h"
#include "block.h"
#include "control.h"
#include "menu.h"
#include "font.h"
#include "slots.h"

Menu::Menu(char **text, int length) : textptr(text), numitems(length)
{
	current_item=0;
	int xmax=0;
	for(int i=0; i<length; i++)
	{
		if(strlen(textptr[i])>xmax) xmax=strlen(textptr[i]);
	}
	ystart=(getScreenHeight()-(numitems+1)*8)/2;
	xstart=(getScreenWidth()-xmax*8)/2;
	yend=ystart+(numitems)*8;
	xend=xstart+xmax*8;
	
	arrow.gifLoadAndCut("gfx/arrow.gif",MENUSLOT);
	arrow.setPos(xstart-arrow.getWidth(),ystart-4);
	arrow.setVisible(true);
	arrow2.gifLoadAndCut("gfx/arrow2.gif",MENUSLOT+1);
	arrow2.setPos(xend,ystart-4);
	arrow2.setVisible(true);
}

// returns choice, or 255 if fire is not pressed
int
Menu::choice(void)
{
	if(control->test(FIRE1))
		return current_item;
	else
		return 255;
}

void
Menu::setControl(Control *c)
{
	control=c;
}

void
Menu::move(void)
{
	static int last=0;

	arrow.setVisible(true);
	arrow2.setVisible(true);
	control->fetch();
	if(control->test(UP))
	{ 
		if(last!=1)
		{
			current_item--; 
			if(current_item<0)
			{
				current_item=numitems-1;
				arrow.setPos(arrow.getXp(), yend-12);
				arrow2.setPos(arrow2.getXp(), yend-12);
			}
			else
			{
				arrow.move(0,-8);
				arrow2.move(0,-8);
			}
		}
		last=1;
	}
	else if(control->test(DOWN))
	{ 
		if(last!=2)
		{
			current_item++; 
			if(current_item>=numitems)
			{ 
				current_item=0;
				arrow.setPos(arrow.getXp(), ystart-4);
				arrow2.setPos(arrow2.getXp(), ystart-4);
			}
			else
			{
				arrow.move(0,8);
				arrow2.move(0,8);
			}
		}
		last=2;
	}
	else 
		last=0;
}

void
Menu::paste(void)
{
	int y=ystart;
	for(int i=0; i<numitems; i++)
	{
		centre(textptr[i],y);
		y+=8;
	}
}

void
Menu::centre(char *t, int y)
{
	int x=(getScreenWidth()-(strlen(t)*8))/2;
	printor(t,getGraphMem(),x,y);
}

void
Menu::getBack(void)
{
	back.cut(xstart,ystart,xend,yend);
}

void
Menu::replace(void)
{
	back.paste(xstart,ystart);
}

void
Menu::update(void)
{
	replace();
	move();
	getBack();
	paste();
}
