/*
**  wt -- a 3d game engine
**
**  Copyright (C) 1994 by Chris Laurel
**  email:  claurel@mr.net
**  snail mail:  Chris Laurel, 5700 W Lake St #208,  St. Louis Park, MN  55416
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/


typedef struct {
     int event_number;
     char *tclproc;
} Update_event;


typedef struct {
     Tcl_Interp *interp;
     int event_num;
#ifdef TCLUPDATE_C_
     List *event_list;
#endif
} Updater;


extern Updater *updater_create(Tcl_Interp *interp);
extern int updater_add_event(Updater *u, char *event);
extern void updater_run(Updater *u);
extern void updater_close(Updater *u);
