
struct texture {
    name
    file
}

proc CreateTxDlg {} {
    global texturedir txfile txname
    toplevel .txdlg
    wm minsize .txdlg 300 320
    wm geometry .txdlg 300x320
    wm title .txdlg Textures
    frame .txdlg.top
    frame .txdlg.middle
    frame .txdlg.bot
    label .txdlg.top.label -text "Name of Texture:"
    entry .txdlg.top.entry -width 25 -textvariable txname
    pack .txdlg.top.label .txdlg.top.entry -side left
    pack .txdlg.top -side top

    listbox .txdlg.middle.box -geometry 20x15 \
	-yscrollcommand ".txdlg.middle.scroll set" \
	-relief sunken -exportselection false
    scrollbar .txdlg.middle.scroll -orient vertical \
	-command ".txdlg.middle.box yview" \
	-relief sunken

    pack .txdlg.middle.box -side left -expand yes -fill both
    pack .txdlg.middle.scroll -side right -fill y
    button .txdlg.bot.b1 -text "Add Texture" \
	-command { AddTexture $txname }
    button .txdlg.bot.b2 -text Close \
	-command { wm withdraw .txdlg }
    pack .txdlg.bot.b1 .txdlg.bot.b2 -side left -padx 1c
    pack .txdlg.middle -side top -expand yes -fill both
    pack .txdlg.bot -side top
    set txfile [exec ls -1 $texturedir]
    foreach i $txfile {
	.txdlg.middle.box insert end $i
    }
    tk_listboxSingleSelect .txdlg.middle.box
    wm withdraw .txdlg
}

proc FindTexture { name } {
    global texture tindex
    if {[info exists texture]} {
	foreach i [array names texture] {
	    if {"[texture-name $texture($i)]"=="$name"} {
		return $i
	    }
	}
    }
}

proc AddTexture { name } {
    global texture tindex txfile
    if {"[set index [FindTexture $name]]"==""} {
	set index $tindex
	incr tindex
    }
    set texture($index) \
	"$name [lindex $txfile [.txdlg.middle.box curselection]]"
    UpdateTextures
}

proc CheckTextures {} {
    global wall region texture
    setbusy 1 "Checking wall textures ..."
    foreach i [array names wall] {
	set used([wall-texture $wall($i)]) 1
	if {"[FindTexture [wall-texture $wall($i)]]"==""} {
	    set undefined([wall-texture $wall($i)]) 1
	}
    }
    setbusy 0
    setbusy 1 "Checking region textures ..."
    foreach i [array names region] {
	set used([lindex $region($i) 2]) 1
	if {"[FindTexture [lindex $region($i) 2]]"==""} {
	    set undefined([lindex $region($i) 2]) 1
	}
	set used([lindex $region($i) 3]) 1
	if {"[FindTexture [lindex $region($i) 3]]"==""} {
	    set undefined([lindex $region($i) 3]) 1
	}
    }
    setbusy 0
    wm deiconify .info
    raise .info

    set w .info.top.text
    $w delete 0.0 end
    $w insert insert "Undefined textures:\n"
    if {[info exists undefined]} {
	foreach i [array names undefined] {
	    $w insert insert $i\n
	}
    }
    $w insert insert "Unused textures:\n"
    foreach i [array names texture] {
	if {![info exists used([texture-name $texture($i)])] }  {
	    $w insert insert [texture-name $texture($i)]\n
	}
    }
}


proc UpdateTextures { } {
    global texture tindex
    .prefsdlg.middle.left.box delete 0 end
    .regdlg.middle.middle1.box delete 0 end
    .regdlg.middle.middle2.box delete 0 end
    if {[info exists texture]} {
	for { set i 0 } { $i<$tindex } { incr i } {
	    .prefsdlg.middle.left.box insert end [texture-name $texture($i)]
	    .regdlg.middle.middle1.box insert end [texture-name $texture($i)]
	    .regdlg.middle.middle2.box insert end [texture-name $texture($i)]
	}
    }
}

