#ifndef __RAWKS_STRUCT__
#define __RAWKS_STRUCT__

#include <sys/types.h>
#include "gl.h"
#include <stdio.h>

/* Used in the lexical analyzer */
typedef enum token_t {
  T_AUTHOR,
  T_BONUS,
  T_CHILD,
  T_COMMA,
  T_COUNT,
  T_DISTPOSITION,
  T_EOF,
  T_EQUAL,
  T_EXPLCOLOR,
  T_FRAMEDELAY,
  T_GEOMETRY,
  T_LBRACK,
  T_LEVEL,
  T_LEVELSIZE,
  T_LIFESPAN,
  T_MAXLIFESPAN,
  T_MAXSHOTS,
  T_MAXSPEED,
  T_MINLIFESPAN,
  T_MINSPEED,
  T_NAME,
  T_NL,
  T_NUM,
  T_NUMLIVES,
  T_POINTS,
  T_RBRACK,
  T_ROCK,
  T_SCALE,
  T_SEMI,
  T_SFXID,
  T_SPEED,
  T_STARTBOXSIZE,
  T_STARTBOXX,
  T_STARTBOXY,
  T_STRING,
  T_TEXT,
  T_TIMELIMIT,
  T_WORD,
  T_XPOSITION,
  T_YPOSITION
} TOKEN;

typedef struct {
  int lineno;
  TOKEN tok;
  char string[1024];
  float num;
} tok_info;

typedef struct {
  int logo;
  int nosound;
  int nodbuff;
  int noborder,fullscreen;
  int xoff,yoff,xsize,ysize;
  char username[MAX_SCORENAME];
  int drock;
} cmd_line_opts;

typedef struct {
  char *filename;
  int repeat,maxcount,pri;
} sfx_info;

typedef struct {
  float x,y,z;
  unsigned long flags; /* Misc flags (draw line?, etc) */
  unsigned int color; /* Cpack'ed color */
} xyz;

typedef struct {
  xyz V[4];
  float inertiax,inertiay,friction;
  float ttl;
  int player,exempt;
  unsigned long color; /* Used for different colored explosions or thrust */
} trajectory;

typedef struct {
  char name[MAX_SCORENAME];
  unsigned int score;
  float accuracy;
  float time;
} level_high;

typedef struct {
  level_high score;
  level_high acc;
  level_high time;
} mission_high;

typedef struct rock_ {
  xyz V[4];
  float inertiax,inertiay,friction; /* Should be same as trajectory */
  float unused[3]; /* Update trajectory might mess with these */
  unsigned long color; /* Used for explosion color */
  float framedelay;
  int frame_ctr[2];
  float minx,maxx,miny,maxy;
  /* */
  float max_speed;
  float min_speed;
  float maxlifespan;
  float minlifespan;
  float lifespan;
  float xposition;
  float yposition;
  float distposition;
  float age;
  float frame_age;
  int num_frames;
  int num_verts;
  xyz ***vertex; /* [frame][vertex]->x [frame][vertex]->y */
  int rocksize; /* Phase out in favor of scale (?) */
  int childrock_id; /* Not yet implemented (?) */
  time_t lastmod; /* Use to see if newer geometry exists */
  char *name;
  char *author;
  char *text; /* Message when rock is killed */
  int value;
  int rockcount;
  float scale;
  int sfxid;
  struct rock_ *child,*sibling; /* For dag configuration */
  struct rock_ *next,*prev; /* For linked list configuration */
} rock;

typedef struct {
  rock *rocks;     /* DAG with rock names */
  int numlives;    /* How many extra ships to get on this level */
  int bonus;       /* Multiply this by accuracy to compute bonus */
  float levelsize; /* How big is the screen - cur not used */
  float startboxsize; /* How big is the start box (where players appear) */
  float startx;    /* Xposition of startbox (defaults to 0) */
  float starty;    /* Yposition of startbox (defaults to 0) */
  float timelimit; /* If this expires, you lose your entire mission */
  float maxshots;  /* You only have this many shots to complete level
		      0 == unlimited */
  char *name;
  char *author;
} level;

typedef struct {
  char *name;   /* Mission name */
  level **level; /* Array of level pointers */
  int numlevels;/* How big is the array of levels? */
  int numlives;
  mission_high *high;
  unsigned int topscore;
  char topname[MAX_SCORENAME];
  unsigned int high_checksum; /* Use to see if high score file has changed */
  unsigned int miss_checksum; /* Use to see if mission file has changed */
} mission;

typedef struct {
  int numverts;
  xyz *verts;
  float x0,y0,x1,y1; /* bounding square */
} object_geom;

typedef struct {
  xyz V[4];
  float inertiax,inertiay,friction; /* Should be same as trajectory */
  float unused[3];
  unsigned long color; /* Cpacked color value from ship_color() */
  float minx,maxx,miny,maxy;
  int exempt; /* Exemptions from collision detection */
  int numverts; /* Only supports one continuous face */
  int allclear; /* Set at same time as exempt, but only cleared once/frame */
  object_geom *modg; /* Modified (rotate/xlate) versions of geom */
  rock *ship;
  rock *thrust;
  unsigned short rotation[2]; /* 0 - 65535 - this autowraps with ++ operator */
  int rot[2];
  char message[80]; /* Some message that can be displayed from killing rock */
  char name[MAX_SCORENAME]; /* Players name / initials */
  float messagelife; /* How long before erasing message */
  int startscore; /* Score at the beginning of the level */
  int startfired; /* Number of shots at beginning of the level */
  int starthit;   /* Number of hits at the beginning of the level */
  int score;
  int fired;
  int hit;
  int numlives;
  float dead;
  float finishtime;
  int thrusting;
  int numbullets;
  int leftkey;
  int rightkey;
  int thrustkey;
  int firekey;
  int hyperkey;
  int nofire;
  int rapid;
} playerinfo;

#endif /* __RAWKS_STRUCT__ */
