#include <stdio.h>
#include "gldevice.h"
#include "defines.h"
#include "struct.h"
#include "globals.h"
#include "protos.h"

#define WHEELSIZE 10

static void instructions(void);
static unsigned int mycolors[WHEELSIZE];

static void initwheelcolor(void)
{
  unsigned char intensity;
  int i;

  for(i=0;i<WHEELSIZE;i++) {
    intensity = (unsigned char) ((((float)WHEELSIZE-i)/(WHEELSIZE-1))*255.0);
    mycolors[i] = intensity + (intensity<<8) + (intensity<<16);
  }
}

level *getmission()
{
  level *tlevel = Level;
  int selected,not_done=1;
  int i,rval;
  short val;
#define NUM_GETMIS_FONTS 10
  static int vf[NUM_GETMIS_FONTS]={-1};

  Game_over = 0;

  if(vf[0]<0) {
    for(i=0;i<NUM_GETMIS_FONTS;i++)
      vf[i] = openvecfont(40,25,0.7);
  }

  initwheelcolor();
  selected = Selected_mission;
  instructions();

#ifndef __LINUX__
  qdevice(HKEY);
  qdevice(LKEY);
  qdevice(JKEY);
  qdevice(KKEY);
#endif
  qdevice(WINQUIT);
  qdevice(WINSHUT);
  qdevice(PAGEUPKEY);
  qdevice(PAGEDOWNKEY);
  qdevice(LEFTARROWKEY);
  qdevice(RIGHTARROWKEY);
  qdevice(UPARROWKEY);
  qdevice(DOWNARROWKEY);
  qdevice(ESCKEY);
  qdevice(RETKEY);
  qdevice(PADENTER);

  while(not_done==1) {
    C_BLACK;
    clear();
#ifdef __LINUX__
    instructions();
#endif

    for(i=MAX(0,selected-WHEELSIZE);
	i<MIN(Num_missions,selected+WHEELSIZE);i++) {
      int colorind;

      colorind = MIN(MAX(0,ABS(i-selected)),(WHEELSIZE-1));
      mmode(MVIEWING);
      loadmatrix(Identity);
      rotate((i-selected+0.3*(i>selected)-0.3*(i<selected))*1800/((WHEELSIZE*2)+1),'x');
      translate(0,0.0,0.5);

      vmov2(vf[0],0.0,0.0);
      if(i == selected) {
	vccprint(vf[0],NORMALDRAW,0x000055,0x5555FF,"                      ");
	vmovrel2(vf[0],0.0,-1.0);
	vccprint(vf[0],NORMALDRAW,0x000055,0x5555FF,amh_basename(Mission_list[i]->name));
      }
      else {
	cpack(mycolors[colorind]);
	vcprint(vf[0],amh_basename(Mission_list[i]->name));
      }
    }
    loadmatrix(Identity);
    my_swapbuffers(NORMALDRAW);

    while(qtest()) {
      rval = qread(&val);
      if(rval == WINSHUT || rval == WINQUIT) closeall();
      else if(rval == REDRAW) {
	setwinattr();
	instructions();
      }
      else if(!val) switch(rval) {
	case RETKEY:
	case PADENTER:
	  not_done = 0;
	  break;
	case ESCKEY:
	  not_done = 2;
	  break;
	default:
	  break;
      }
      else if(val) switch(rval) {
	case PAGEUPKEY:
	  selected = 0;
	  break;
	case PAGEDOWNKEY:
	  selected = Num_missions - 1;
	  break;
#ifndef __LINUX__
	case HKEY:
#endif
	case LEFTARROWKEY:
	  if((selected-=10) < 0) selected = 0;
	  break;
#ifndef __LINUX__
	case LKEY:
#endif
	case RIGHTARROWKEY:
	  if((selected+=10) >= Num_missions) selected = Num_missions-1;
	  break;
#ifndef __LINUX__
	case JKEY:
#endif
	case DOWNARROWKEY:
	  if(++selected >= Num_missions) selected = Num_missions-1;
	  break;
#ifndef __LINUX__
	case KKEY:
#endif
	case UPARROWKEY:
	  if(--selected < 0) selected = 0;
	  break;
	default:
	  break;
      }
    }
  }
#ifndef __LINUX__
  unqdevice(HKEY);
  unqdevice(LKEY);
  unqdevice(JKEY);
  unqdevice(KKEY);
#endif
  unqdevice(PAGEUPKEY);
  unqdevice(PAGEDOWNKEY);
  unqdevice(LEFTARROWKEY);
  unqdevice(RIGHTARROWKEY);
  unqdevice(UPARROWKEY);
  unqdevice(DOWNARROWKEY);
  unqdevice(RETKEY);
  unqdevice(PADENTER);

  mmode(MVIEWING);
  loadmatrix(Identity);
  ortho(-1,1,-1,1,1,-1);
  clear_overlay();

  Game_over = 1; /* This is very important */

  if(!not_done) {
#if 0
    Level = tlevel; /* Allow them to free up the old level */

    Taking this out prevents loading if already loaded.
    I added a key to reload
    current level (for level development)
#endif
    Next_level = 0;
    Selected_mission = selected;
    if(!Mission_list[Selected_mission]->level) {
      /* Read the levels for this mission */
      read_mission_levels(Mission_list[Selected_mission]);
    }
    return Mission_list[Selected_mission]->level[Next_level];
  }
  else {
    Level = tlevel; /* They pressed escape so keep the same level if any */
    return NULL;
  }
}

static void instructions(void)
{
  drawmode(PUPDRAW);
  Level = NULL;
  clear_overlay();
  mmode(MVIEWING);
  loadmatrix(Identity);
  ortho(-1,1,-1,1,1,-1);
  mapcolor(1,0xAA,0xAA,0xFF);
/*   mapcolor(2,0x22,0x22,0xFF); */
  mapcolor(2,0x00,0x00,0xFF);
  gflush();
  vmov2(Largefont,0.0,-0.0);
  vmovrel2(Largefont,0.0,-11.0);
  vccprint(Largefont,PUPDRAW,2,1,"   Use cursor keys to select mission   ");
  vccprint(Largefont,PUPDRAW,2,1,"press enter to preview selected mission");
  copyright();

  drawmode(NORMALDRAW);
}
