#ifndef __LINUXGL_H__
#define __LINUXGL_H__

#ifdef __LINUX__

#define __GL_GL_H__

#include "rawkey.h"
#include <vga.h>
#include <vgagl.h>

#define LN_DTR(x) ((x)*(M_PI/180.0))

#ifndef TRUE
#define TRUE 1
#endif
#ifndef FALSE
#define FALSE 0
#endif

#define F1KEY              59
#define F2KEY              60
#define F3KEY              61
#define F4KEY              62
#define F5KEY              63
#define F6KEY              64
#define F7KEY              65
#define F8KEY              66
#define F9KEY              67
#define F10KEY             68
#define F11KEY             56
#define F12KEY             57
#define PADENTER           KEYPAD_CENTER /* Incorrect, until find pad enter */
#define LEFTARROWKEY       CURSOR_LEFT
#define UPARROWKEY         CURSOR_UP
#define DOWNARROWKEY       CURSOR_DOWN
#define RIGHTARROWKEY      CURSOR_RIGHT
#define PAGEDOWNKEY        PAGE_DOWN
#define PAGEUPKEY          PAGE_UP
#define ESCKEY             ESCAPE_KEY
#define MINUSKEY           GRAY_MINUS
#define YKEY               (scancode_trans('y'))
#define NKEY               (scancode_trans('n'))
#define RETKEY             ENTER_KEY
#define BACKSPACEKEY       BACKSPACE
#define DELKEY             DELETE_KEY
#define PAUSEKEY           -1
#define INPUTCHANGE        -2
#define LEFTMOUSE          -3
#define KEYBD              -4
#define RAWKEYBD           -5
#define SPACEKEY           -6
#define EQUALKEY           -7

typedef enum {
  PUPDRAW=-255,WINSHUT,WINQUIT,REDRAW
} irix_gl_qevents;

typedef enum {
  GD_XPMAX,GD_YPMAX
} GDescType;

typedef enum {
  NORMALDRAW=0,OVERDRAW
} irix_draw_modes;

typedef enum {
  MVIEWING=0,MPROJECTION
} irix_proj_modes;

typedef float Matrix[4][4];
extern Matrix Identity;

extern void gl_myfillbox   ( float fx1, float fy1, float fw, float fh );
extern void sbox           ( int x1,int y1,int x2,int y2 );
extern void ortho          ( int x1,int x2,int y1,int y2,int z1,int z2 );
extern void ortho2         ( int x1,int x2,int y1,int y2 );
extern void viewport       ( int x1,int x2,int y1,int y2 );
extern void qdevice        ( int device );
extern void unqdevice      ( int device );
extern void winclose       ( int window );
extern void frontbuffer    ( int onoff );
extern void backbuffer     ( int onoff );
extern void drawmode       ( int mode );
extern void mapcolor       ( int index, float _r, float _g, float _b );
extern void color          ( int c );

extern void foreground     ( void );
extern void swapbuffers    ( void );
extern void curson         ( void );
extern void winconstraints ( void );
extern void noborder       ( void );
extern void gflush         ( void );
extern void cursoff        ( void );
extern void doublebuffer   ( void );
extern void singlebuffer   ( void );
extern void RGBmode        ( void );
extern void gconfig        ( void );

extern void cpack(unsigned int cpc);
extern void bgnclosedline(void);
extern void bgnpolygon(void);
extern void endclosedline(void);
extern void endpolygon(void);
extern void endline(void);
extern void bgnline(void);
extern void v2f(float *f);
extern void v3f(float *f);
extern void clear(void);
extern int qread(short *val);
extern int winopen(const char *);
extern void loadmatrix ( Matrix mat );
extern void rotate ( int angle, char axis );
extern void translate ( float x, float y, float z );
extern void mmode ( int matmode );

#endif /* !__LINUX__ */

#endif /* !__LINUXGL_H__ */
