/* --------------------------------- joyport.c ----------------------------- */

/* This is part of the flight simulator 'fly8'.
 * Author: Eyal Lebedinsky (eyal@ise.canberra.edu.au).
*/

/* read a JOYSTICK using <linux/joystick.h>.
*/

#include "fly.h"

#ifdef HAVE_JOYSTICK
#ifdef USE_JOY

#include "stick.h"

#include <unistd.h>
#include <fcntl.h>
#include <stdlib.h>
#include <sys/ioctl.h>
#include <linux/joystick.h>


extern int
initjoy (int which, int fjs, int opts)
{
	struct JS_DATA_TYPE	jsdata;
	long			l;

	l = -1L;	/* get around joystick driver bug */
	if (ioctl (fjs, JS_SET_TIMELIMIT, &l) < 0)
		return (1);

	l = 5000L;
	if (ioctl (fjs, JS_SET_TIMEOUT, &l) < 0)
		return (1);

	jsdata.x = jsdata.y = 0;
	if (ioctl (fjs, JS_SET_CAL, &jsdata) < 0)
		return (1);
	return (0);
}

extern Uint
readjoy (int which, int fjs, STICK *j, int mask, int opts)
{
	struct JS_DATA_TYPE_LONG jsdata;
	int	len;

	len = (opts & READA3) ? JS_RETURN_LONG : JS_RETURN;
	if (read (fjs, (void *)&jsdata, len) != len)
		return (1);

	j->a[0] = jsdata.x;
	j->a[1] = jsdata.y;
	j->a[2] = jsdata.x2;
	j->a[3] = jsdata.y2;
	j->b[0] = T(jsdata.buttons & 0x0001);
	j->b[1] = T(jsdata.buttons & 0x0002);
	j->b[2] = T(jsdata.buttons & 0x0004);
	j->b[3] = T(jsdata.buttons & 0x0008);

	return (0);
}

#endif
#endif
