/*
 * autostart - start up the distributor if it's not around.
 */

#include "local.h"
#include "defs.h"
#include <string.h>

start_distributor ()
{
	int	pid;
	char filename[1024];

	switch (pid = fork()) {
	case 0:
		(void) setpgrp (0, getpid());
		sprintf(filename, "%s/%s", HEARTSLIB, HEARTS_DIST);
		execl (filename, "hearts_dist", 0);
		exit (1);
	case -1:
		perror ("fork");
		exit (1);
	default:
		while (wait (0) != pid)
			;
	}
}
