/*
 * ------------------------------------------------------------------
 * Monster.cc - Monster Class Implementation
 * Created by Robert Heller on Sat Mar  4 12:28:10 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Monster.cc,v $
// Revision 1.11  1995/06/18  20:06:31  heller
// Small typo in Postscript code
//
// Revision 1.10  1995/06/18  17:38:55  heller
// Updated the Postscript code (cleaned it up, added RPGDict, etc.)
//
// Revision 1.9  1995/03/24  00:01:34  heller
// Converted MonsterHandles from static to static member
//
// Revision 1.8  1995/03/18  23:19:48  heller
// Add AllMonsters and FindMonstersBy
//
// Revision 1.7  1995/03/18  05:18:26  heller
// Add '#include <stdlib.h>' for decl of free()
//
// Revision 1.6  1995/03/18  05:01:37  heller
// Memory leak with Tcl_SplitList...
//
// Revision 1.5  1995/03/17  03:15:18  heller
// Make dam/att and no apearing ranges (low, high)
//
// Revision 1.4  1995/03/16  00:27:08  heller
// Add type hack
//
// Revision 1.3  1995/03/14  22:16:25  heller
// Update to use handles
//
// Revision 1.2  1995/03/12  05:46:17  heller
// Fixed readline problems
// Added no option for object command
//
// Revision 1.1  1995/03/05  00:59:22  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: Monster.cc,v 1.11 1995/06/18 20:06:31 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Monster.h>
#include <Dice.h>
#include <tclExtend.h>
#include <string.h>
#include <stdlib.h>

FreqType::FreqType(String v)
{
	if (v == "Unique") value = Unique;
	else if (v == "VeryRare") value =  VeryRare;
	else if (v == "Rare") value = Rare;
	else if (v == "Uncommon") value =  Uncommon;
	else if (v == "Common") value = Common;
	else value = Bogus;
}

IntelligenceRating::IntelligenceRating(String v)
{
	if (v == "Non") value = Non;
	else if (v == "Animal") value = Animal;
	else if (v == "Semi") value = Semi;
	else if (v == "Low") value = Low;
	else if (v == "Average") value = Average;
	else if (v == "Very") value = Very;
	else if (v == "Highly") value = Highly;
	else if (v == "Exceptionally") value = Exceptionally;
	else if (v == "Genius") value = Genius;
	else if (v == "Supra-Genius") value = SupraGenius;
	else if (v == "Godlike") value = Godlike;
	else value = Bogus;
}


Monster::~Monster()
{
}

int Monster::ReadFromFile(char *filename)
{
	int temp;
	ifstream stream(filename);
	if (!stream) return 0;
	stream >> hitpoints;
	if (!stream) return 0;
	stream >> temp;
	if (!stream) return 0;
	hdie = temp;
	stream >> temp;
	if (!stream) return 0;
	ndie = temp;
	stream >> temp;
	if (!stream) return 0;
	armclass = temp;
	stream >> temp;
	if (!stream) return 0;
	move = temp;
	stream >> temp;
	if (!stream) return 0;
	move_fly = temp;
	stream >> temp;
	if (!stream) return 0;
	move_swim = temp;
	stream >> temp;
	if (!stream) return 0;
	move_burrow = temp;
	stream >> temp;
	if (!stream) return 0;
	move_web = temp;
	stream >> temp;
	if (!stream) return 0;
	percentLair = temp;
	stream >> temp;
	if (!stream) return 0;
	numatt = temp;
	stream >> temp;
	if (!stream) return 0;
	damatt.l = temp;
	stream >> temp;
	if (!stream) return 0;
	damatt.h = temp;
	stream >> temp;
	if (!stream) return 0;
	magres = temp;
	stream >> temp;
	if (!stream) return 0;
	noapearing.l = temp;
	stream >> temp;
	if (!stream) return 0;
	noapearing.h = temp;
	stream >> intelligence;
	if (!stream) return 0;
	stream >> frequency;
	if (!stream) return 0;
	stream >> hittype;
	if (!stream) return 0;
	stream >> size;
	if (!stream) return 0;
	stream.get();	// gobble \n after size.
	if (!stream) return 0;
	static char buffer[2048];
	stream.getline(buffer,2048,'\n'); Name = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Alignment = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); TreasureType = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); SpecialAttacks = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); SpecialDefences = buffer;
	if (!stream) return 0;
	stream.getline(buffer,2048,'\n'); Psionics = buffer;
	if (!stream) return 0;
	Comments = "";
	while (stream)
	{
		stream.getline(buffer,2048,EOF); Comments += buffer;
	}
	if (!stream && !stream.eof()) return 0;
	return 1;	
}

int Monster::WriteToFile(char *filename)
{
	ofstream stream(filename);
	if (!stream) return 0;
	stream << hitpoints << " ";
	if (!stream) return 0;
	stream << ((int) hdie) << " ";
	if (!stream) return 0;
	stream << ((int) ndie) << " ";
	if (!stream) return 0;
	stream << ((int) armclass) << " ";
	if (!stream) return 0;
	stream << ((int) move) << " ";
	if (!stream) return 0;
	stream << ((int) move_fly) << " ";
	if (!stream) return 0;
	stream << ((int) move_swim) << " ";
	if (!stream) return 0;
	stream << ((int) move_burrow) << " ";
	if (!stream) return 0;
	stream << ((int) move_web) << " ";
	if (!stream) return 0;
	stream << ((int) percentLair) << " ";
	if (!stream) return 0;
	stream << ((int) numatt) << " ";
	if (!stream) return 0;
	stream << ((int) damatt.l) << " ";
	if (!stream) return 0;
	stream << ((int) damatt.h) << " ";
	if (!stream) return 0;
	stream << ((int) magres) << " ";
	if (!stream) return 0;
	stream << ((int) noapearing.l) << endl;
	if (!stream) return 0;
	stream << ((int) noapearing.h) << endl;
	if (!stream) return 0;
	stream << intelligence << endl;
	if (!stream) return 0;
	stream << frequency << endl;
	if (!stream) return 0;
	stream << hittype << endl;
	if (!stream) return 0;
	stream << size << endl;
	if (!stream) return 0;
	stream << Name << endl;
	if (!stream) return 0;
	stream <<  Alignment << endl;
	if (!stream) return 0;
	stream <<  TreasureType << endl;
	if (!stream) return 0;
	stream <<  SpecialAttacks << endl;
	if (!stream) return 0;
	stream <<  SpecialDefences << endl;
	if (!stream) return 0;
	stream <<  Psionics << endl;
	if (!stream) return 0;
	stream <<  Comments << endl;
	if (!stream) return 0;
	return 1;	
}

#include <RPGDict.h>

int Monster::PrintToFile(char *filename,PrintType typ)
{
	opfstream stream(filename);
	if (!stream) return 0;
	switch (typ)
	{
		case text:
			stream << Name << endl;
			if (!stream) return 0;
			stream << "Frequency: " << frequency << endl;
			if (!stream) return 0;
			if (noapearing.l == noapearing.h)
				stream << "No. Appearing: " << ((int) noapearing.l) << endl;
			else
				stream << "No. Appearing: " << ((int) noapearing.l) << "-" << ((int) noapearing.h) << endl;
			if (!stream) return 0;
			stream << "Armor Class: " << ((int) armclass) << endl;
			if (!stream) return 0;
			stream << "Move: " << ((int) move) << '"';
			if (!stream) return 0;
			if (move_fly != 0)
			{
				stream << "/" << ((int) move_fly) << '"' << endl;
			} else if (move_swim != 0)
			{
				stream << "//" << ((int) move_swim) << '"' << endl;
			} else if (move_burrow != 0)
			{
				stream << "(" << ((int) move_burrow) << "\")" << endl;
			} else if (move_web != 0)
			{
				stream << "*" << ((int) move_web) << '"' << endl;
			} else  stream << endl;
			if (!stream) return 0;
			if (hittype == Dice)
			{
				stream << "Hit Dice: " << ((int) ndie) << "d" << ((int) hdie) << endl;
			} else
			{
				stream << "Hit Points: " << hitpoints << endl;
			}
			if (!stream) return 0;
			stream << "% in lair: " << ((int) percentLair) << endl;
			if (!stream) return 0;
			stream << "Treasure type: " << TreasureType << endl;
			if (!stream) return 0;
			stream << "No. of attacks: " << ((int) numatt) << endl;
			if (!stream) return 0;
			if (damatt.l == damatt.h)
				stream << "Damage/Attack: " << ((int) damatt.l) << endl;
			else
				stream << "Damage/Attack: " << ((int) damatt.l) << "-" << ((int) damatt.h)<< endl;
			if (!stream) return 0;
			stream << "Special Attacks: " << SpecialAttacks << endl;
			if (!stream) return 0;
			stream << "Special Defences: " << SpecialDefences << endl;
			if (!stream) return 0;
			stream << "Magic Resistance: " << ((int) magres) << endl;
			if (!stream) return 0;
			stream << "Intelligence: " << intelligence << endl;
			if (!stream) return 0;
			stream << "Alignment: " << Alignment << endl;
			if (!stream) return 0;
			stream << "Size: " << size << "'" << endl;
			if (!stream) return 0;
			stream << "Psionics: " << Psionics << endl;
			if (!stream) return 0;
			stream << "Comments: " << Comments << endl;
			if (!stream) return 0;
			break;
		case html:
			stream << "<title>" << Name << "</title>" << endl;
			if (!stream) return 0;
			stream << "<h1>" << Name << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Frequency: " << frequency << "</h1><br>" << endl;
			if (!stream) return 0;
			if (noapearing.l == noapearing.h)
				stream << "<h1>No. Appearing: " << ((int) noapearing.l) << "</h1><br>" << endl;
			else
				stream << "<h1>No. Appearing: " << ((int) noapearing.l) << "-" << ((int) noapearing.h) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Armor Class: " << ((int) armclass) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Move: " << ((int) move) << '"';
			if (!stream) return 0;
			if (move_fly != 0)
			{
				stream << "/" << ((int) move_fly) << '"' << "</h1><br>" << endl;
			} else if (move_swim != 0)
			{
				stream << "//" << ((int) move_swim) << '"' << "</h1><br>" << endl;
			} else if (move_burrow != 0)
			{
				stream << "(" << ((int) move_burrow) << "\")" << "</h1><br>" << endl;
			} else if (move_web != 0)
			{
				stream << "*" << ((int) move_web) << '"' << "</h1><br>" << endl;
			} else  stream << "</h1><br>" << endl;
			if (!stream) return 0;
			if (hittype == Dice)
			{
				stream << "<h1>Hit Dice: " << ((int) ndie) << "d" << ((int) hdie) << "</h1><br>" << endl;
			} else
			{
				stream << "<h1>Hit Points: " << hitpoints << "</h1><br>" << endl;
			}
			if (!stream) return 0;
			stream << "<h1>% in lair: " << ((int) percentLair) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Treasure type: " << TreasureType << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>No. of attacks: " << ((int) numatt) << "</h1><br>" << endl;
			if (!stream) return 0;
			if (damatt.l == damatt.h)
				stream << "<h1>Damage/Attack: " << ((int) damatt.l) << "</h1><br>" << endl;
			else
				stream << "<h1>Damage/Attack: " << ((int) damatt.l) << "-" << ((int) damatt.h) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Special Attacks: " << SpecialAttacks << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Special Defences: " << SpecialDefences << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Magic Resistance: " << ((int) magres) << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Intelligence: " << intelligence << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Alignment: " << Alignment << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Size: " << size << "'" << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "<h1>Psionics: " << Psionics << "</h1><br>" << endl;
			if (!stream) return 0;
			stream << "Comments: " << Comments << endl;
			if (!stream) return 0;
			break;
		case postscript:
			RPGDict(stream,Name);
			stream << "BIGFONT" << endl;
			stream << "(" << PSQuote(Name) << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Frequency: " << frequency
			       << ") showhead" << endl;
			if (!stream) return 0;
			stream << "(No. Appearing: " << ((int) noapearing.l);
			if (noapearing.l != noapearing.h) stream << "-" << ((int) noapearing.h);
			stream << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Armor Class: " << ((int) armclass)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Move: " << ((int) move) << '"';
			if (!stream) return 0;
			if (move_fly != 0)
			{
				stream << "/" << ((int) move_fly) << '"'; 
			} else if (move_swim != 0)
			{
				stream << "//" << ((int) move_swim) << '"'; 
			} else if (move_burrow != 0)
			{
				stream << "\\(" << ((int) move_burrow) << "\"\\)";
			} else if (move_web != 0)
			{
				stream << "*" << ((int) move_web) << '"';
			}
			if (!stream) return 0;
			stream << ") showline" << endl;
			if (!stream) return 0;
			stream << "(";
			if (!stream) return 0;
			if (hittype == Dice)
			{
				stream << "Hit Dice: " << ((int) ndie) << "d" << ((int) hdie);
			} else
			{
				stream << "Hit Points: " << hitpoints;
			}
			if (!stream) return 0;
			stream << ") showline" << endl;
			if (!stream) return 0;
			stream << "(";
			if (!stream) return 0;
			stream << "\\% in lair: " << ((int) percentLair);
			if (!stream) return 0;
			stream << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Treasure type: " << PSQuote(TreasureType)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(No. of attacks: " << ((int) numatt)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Damage/Attack: " << ((int) damatt.l);
			if (damatt.l != damatt.h) stream << "-" << ((int) damatt.h);
 			stream << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Special Attacks: " << PSQuote(SpecialAttacks)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Special Defences: " << PSQuote(SpecialDefences)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Magic Resistance: " << ((int) magres)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Intelligence: " << intelligence
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Alignment: " << PSQuote(Alignment)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Size: " << size << "'"
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Psionics: " << PSQuote(Psionics)
			       << ") showline" << endl;
			if (!stream) return 0;
			stream << "(Comments:) showline newline" << endl;
			if (!stream) return 0;
			stream << "NORMFONT" << endl; if (!stream) return 0;
			stream << "(" << PSQuoteXnewline(Comments)
			       << ") CommentsParagraph" << endl;
			stream << "newpage" << endl;
			if (!stream) return 0;
			RPGDictEnd(stream);
			break;
		default:
			break;
	}
	if (!stream) return 0;
	return 1;	
}

void_pt Monster::Handles = NULL;

int Monster::TclFunction(Tcl_Interp *interp,int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Monster");
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Frequency");
		Tcl_DStringAppendElement(&result,(char*)frequency);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"No.Apearing");
		{
			ostrstream stream;
			stream << ((int) noapearing.l);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) noapearing.h);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"ArmorClass");
		{
			ostrstream stream;
			stream << ((int) armclass);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Move");
		{
			ostrstream stream;
			stream << ((int) move);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) move_fly);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) move_swim);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) move_burrow);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) move_web);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		if (hittype == Points)
		{
			Tcl_DStringAppendElement(&result,"HitPoints");
			ostrstream stream;
			stream << hitpoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		} else if (hittype == Dice)
		{
			Tcl_DStringAppendElement(&result,"HitDice");
			ostrstream stream;
			stream << ((int) ndie) << "d" << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"%Lair");
		{
			ostrstream stream;
			stream << ((int) percentLair);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"TreasureType");
		Tcl_DStringAppendElement(&result,(char*)TreasureType);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"No.Attacks");
		{
			ostrstream stream;
			stream << ((int) numatt);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Damage/Attack");
		{
			ostrstream stream;
			stream << ((int) damatt.l);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		{
			ostrstream stream;
			stream << ((int) damatt.h);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpecialAttacks");
		Tcl_DStringAppendElement(&result,(char*)SpecialAttacks);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpecialDefences");
		Tcl_DStringAppendElement(&result,(char*)SpecialDefences);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MagicResistance");
		{
			ostrstream stream;
			stream << ((int) magres);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Intelligence");
		Tcl_DStringAppendElement(&result,(char*)intelligence);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Alignment");
		Tcl_DStringAppendElement(&result,(char*)Alignment);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Size");
		{
			ostrstream stream;
			stream << size;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Psionics");
		Tcl_DStringAppendElement(&result,(char*)Psionics);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Comments");
		Tcl_DStringAppendElement(&result,(char*)Comments);
		Tcl_DStringEndSublist(&result);
		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (argc < 2)
	{
		Tcl_AppendResult(interp, "wrong # args: should be \"",
				 argv[0], " option ?arg arg ...?\"",
				 (char *) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Monster", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "write") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!WriteToFile(argv[2]))
		{
			Tcl_AppendResult(interp, "Error writing file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "read") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!ReadFromFile(argv[2]))
		{
			Tcl_AppendResult(interp, "Error reading file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;

	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "alignment") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Alignment,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Alignment = argv[2];
			Tcl_AppendResult(interp,(char*)Alignment,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "treasuretype") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)TreasureType,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			TreasureType = argv[2];
			Tcl_AppendResult(interp,(char*)TreasureType,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "specialattacks") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)SpecialAttacks,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			SpecialAttacks = argv[2];
			Tcl_AppendResult(interp,(char*)SpecialAttacks,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "specialdefences") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)SpecialDefences,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			SpecialDefences = argv[2];
			Tcl_AppendResult(interp,(char*)SpecialDefences,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "psionics") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Psionics,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Psionics = argv[2];
			Tcl_AppendResult(interp,(char*)Psionics,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "comments") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Comments ,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Comments = argv[2];
			Tcl_AppendResult(interp,(char*)Comments,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "intelligence") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)intelligence,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			IntelligenceRating i = IntelligenceRating(argv[2]);
			if (!i)
			{
				 Tcl_AppendResult(interp, "Bad intelligence word: ",
				 		  argv[2],"should be one of {",
				 		  "Non Animal Semi Low Average Very ",
				 		  "Highly Exceptionally Genius ",
				 		  "Supra-Genius Godlike}",
				 		  (char*) NULL);
				 return TCL_ERROR;
			}
			intelligence = i;
			Tcl_AppendResult(interp,(char*)intelligence,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "frequency") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)frequency,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			FreqType f = FreqType(argv[2]);
			if (!f)
			{
				Tcl_AppendResult(interp, "Bad frequency word: ",
						 argv[2],"should be one of {",
						 "Unique VeryRare Rare Uncommon Common}",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			frequency = f;
			Tcl_AppendResult(interp,(char*)frequency,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "hittype") == 0)
	{
		if (argc == 2)
		{
			if (hittype == Points)
				Tcl_AppendResult(interp,"Points",(char *) NULL);
			else if (hittype == Dice)
				Tcl_AppendResult(interp,"Dice",(char *) NULL);
			else	Tcl_AppendResult(interp,"",(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			if (strcmp(argv[2],"Points") == 0)
				hittype = Points;
			else if (strcmp(argv[2],"Dice") == 0)
				hittype = Dice;
			else
			{
				Tcl_AppendResult(interp, "Bad HitType word: ",
						 argv[2],"should be one of {",
						 "Points Dice}",
						 (char*) NULL);
				return TCL_ERROR;
			}
			Tcl_AppendResult(interp,argv[2],(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}

	} else if (strcmp(argv[1], "hitpoints") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << hitpoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			hitpoints = temp;
			ostrstream stream;
			stream << hitpoints;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "hitdie") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			hdie = temp;
			ostrstream stream;
			stream << ((int) hdie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "numhitdie") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) ndie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			ndie = temp;
			ostrstream stream;
			stream << ((int) ndie);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "armorclass") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) armclass);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			armclass = temp;
			ostrstream stream;
			stream << ((int) armclass);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "move") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) move);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			move = temp;
			ostrstream stream;
			stream << ((int) move);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "fly") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) move_fly);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			move_fly = temp;
			ostrstream stream;
			stream << ((int) move_fly);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "swim") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) move_swim);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			move_swim = temp;
			ostrstream stream;
			stream << ((int) move_swim);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "web") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) move_web);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			move_web = temp;
			ostrstream stream;
			stream << ((int) move_web);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "burrow") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) move_burrow);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			move_burrow = temp;
			ostrstream stream;
			stream << ((int) move_burrow);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "percentlair") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) percentLair);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			percentLair = temp;
			ostrstream stream;
			stream << ((int) percentLair);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "numattacks") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) numatt);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			numatt = temp;
			ostrstream stream;
			stream << ((int) numatt);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "damageperattack") == 0)
	{
		if (argc == 2)
		{
			{
				ostrstream stream;
				stream << ((int)damatt.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)damatt.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			damatt.l = damatt.h = temp;
			{
				ostrstream stream;
				stream << ((int)damatt.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)damatt.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else if (argc == 4)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			damatt.l = temp;
			if (Tcl_GetInt(interp,argv[3],&temp) != TCL_OK)
				return(TCL_ERROR);
			damatt.h = temp;
			{
				ostrstream stream;
				stream << ((int)damatt.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)damatt.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value? ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "magicresistance") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << ((int) magres);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			magres = temp;
			ostrstream stream;
			stream << ((int) magres);
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "numappearing") == 0)
	{
		if (argc == 2)
		{
			{
				ostrstream stream;
				stream << ((int)noapearing.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)noapearing.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			noapearing.l = noapearing.h = temp;
			{
				ostrstream stream;
				stream << ((int)noapearing.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)noapearing.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else if (argc == 4)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			noapearing.l = temp;
			if (Tcl_GetInt(interp,argv[3],&temp) != TCL_OK)
				return(TCL_ERROR);
			noapearing.h = temp;
			{
				ostrstream stream;
				stream << ((int)noapearing.l);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			{
				ostrstream stream;
				stream << ((int)noapearing.h);
				_IO_ssize_t i = stream.pcount();
				char *s = stream.str();
				s[i] = '\0';
				Tcl_AppendElement(interp,s);
				stream.freeze(0);
			}
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "size") == 0)
	{
		if (argc == 2)
		{
			ostrstream stream;
			stream << size;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&size) != TCL_OK)
				return(TCL_ERROR);
			ostrstream stream;
			stream << size;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_AppendResult(interp,s,(char *) NULL);
			stream.freeze(0);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," ?value?\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "print") == 0)
	{
		if (argc < 3 || argc > 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " filename ?mode?\"",(char *) NULL);
			return TCL_ERROR;
		}
		PrintType typ = text;
		if (argc == 4)
		{
			if (strcmp(argv[3],"text") == 0) typ = text;
			else if (strcmp(argv[3],"html") == 0) typ = html;
			else if (strcmp(argv[3],"postscript") == 0)
				typ = postscript;
			else
			{
				Tcl_AppendResult(interp, "wrong print mode: ",
						 argv[3]," should be one of {",
						 "text html html}",
						 (char *) NULL);
				return TCL_ERROR;
			}
		}
		if (!PrintToFile(argv[2],typ))
		{
			Tcl_AppendResult(interp, "Error printing to ",
					 argv[2],(char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Monster::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Monster::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}


static void deleteMonster(ClientData clientData)
{
        register Monster *monster = (Monster *) clientData;
        delete monster;
}

static int monsterCommand(ClientData clientData, Tcl_Interp *interp,
                       int argc, char *argv[])
{
	register Monster *monster = (Monster*)clientData;
	return monster->TclFunction(interp,argc,argv);
}

static int monsterCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	register Monster *monster;
	if (argc != 1 && (argc < 23 || argc > 24))
	{
		 Tcl_AppendResult(interp, "Wrong # args: should be \"",
		 		argv[0]," ?name freq {noappear.l noappear.h} ",
				"armorclass move fly swim burrow web ",
				"?nd hd?hitpoints? percentinlair treasure ",
				"numatt {damatt.l damatt.h} specialatt specialdef magicres ",
				"intell alignment size psionics comments?\"", 
				(char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		/* nothing but the handle */
		monster = new Monster;
	} else if (argc == 23)
	{
		/* hitpoints instead of hitdie */
		/* argv[1] : name */
		/* argv[2] : freq */
		FreqType f = argv[2];
		if (!f)
		{
			Tcl_AppendResult(interp, "Bad frequency word: ",
					 argv[2],"should be one of {",
					 "Unique VeryRare Rare Uncommon Common}",
					 (char*) NULL);
			return(TCL_ERROR);
		}
		int noappearL, noappearH, armorclass, move, fly, swim, burrow, web, hp,
		    percentinlair, numatt, damattL, damattH, mr;
		if (Tcl_GetInt(interp,argv[3],&noappearL) != TCL_OK)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[3], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 2)
			{
				Tcl_AppendResult(interp, "Bad number apearing: ",
				argv[3],"should be either an int or a list of two ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&noappearL) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&noappearH) != TCL_OK)
				return(TCL_ERROR);
			free(xargv);
		} else noappearH = noappearL;
		if (Tcl_GetInt(interp,argv[4],&armorclass) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[5],&move) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[6],&fly) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[7],&swim) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[8],&burrow) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[9],&web) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[10],&hp) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[11],&percentinlair) != TCL_OK)
			return(TCL_ERROR);
		/* argv[12] : treasure */
		if (Tcl_GetInt(interp,argv[13],&numatt) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[14],&damattL) != TCL_OK)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[14], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 2)
			{
				Tcl_AppendResult(interp, "Bad damage/attack: ",
						 argv[14],"should be either an int or a list of two ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&damattL) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&damattH) != TCL_OK)
				return(TCL_ERROR);
			free(xargv);
		} else damattH = damattL;
		/* argv[15] specialatt */
		/* argv[16] specialdef */
		if (Tcl_GetInt(interp,argv[17],&mr) != TCL_OK)
			return(TCL_ERROR);
		IntelligenceRating i = IntelligenceRating(argv[18]);
		if (!i)
		{
			Tcl_AppendResult(interp, "Bad intelligence word: ",
					 argv[18],"should be one of {",
					 "Non Animal Semi Low Average Very ",
					 "Highly Exceptionally Genius ",
					 "Supra-Genius Godlike}",
					 (char*) NULL);
			return TCL_ERROR;
		}
		/* argv[19] alignment */
		double s;
		if (Tcl_GetDouble(interp,argv[20],&s) != TCL_OK)
			return TCL_ERROR;
		/* argv[21] psionics */
		/* argv[22] comments */
		monster = new Monster(hp,armorclass,move,fly,swim,burrow,web,
				      percentinlair,numatt,damattL,damattH,mr,
				      noappearL,noappearH,
				      i,f,s,argv[1],argv[19],
				      argv[12],argv[15],argv[16],argv[21],
				      argv[22]);
	} else
	{
		/* hitdie instead of hitpoints */
		/* argv[1] : name */
		/* argv[2] : freq */
		FreqType f = argv[2];
		if (!f)
		{
			Tcl_AppendResult(interp, "Bad frequency word: ",
					 argv[2],"should be one of {",
					 "Unique VeryRare Rare Uncommon Common}",
					 (char*) NULL);
			return(TCL_ERROR);
		}
		int noappearL, noappearH, armorclass, move, fly, swim, burrow, web, hd,nd,
		    percentinlair, numatt, damattL, damattH, mr;
		if (Tcl_GetInt(interp,argv[3],&noappearL) != TCL_OK)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[3], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 2)
			{
				Tcl_AppendResult(interp, "Bad number apearing: ",
				argv[3],"should be either an int or a list of two ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&noappearL) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&noappearH) != TCL_OK)
				return(TCL_ERROR);
			free (xargv);
		} else noappearH = noappearL;
		if (Tcl_GetInt(interp,argv[4],&armorclass) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[5],&move) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[6],&fly) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[7],&swim) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[8],&burrow) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[9],&web) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[10],&nd) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[11],&hd) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[12],&percentinlair) != TCL_OK)
			return(TCL_ERROR);
		/* argv[13] : treasure */
		if (Tcl_GetInt(interp,argv[14],&numatt) != TCL_OK)
			return(TCL_ERROR);
		if (Tcl_GetInt(interp,argv[14],&damattL) != TCL_OK)
		{
			int xargc;
			char **xargv;
			if (Tcl_SplitList(interp, argv[14], &xargc, &xargv) != TCL_OK)
				return(TCL_ERROR);
			if (xargc != 2)
			{
				Tcl_AppendResult(interp, "Bad damage/attack: ",
						 argv[14],"should be either an int or a list of two ints",
						 (char*) NULL);
				return(TCL_ERROR);
			}
			if (Tcl_GetInt(interp,xargv[0],&damattL) != TCL_OK)
				return(TCL_ERROR);
			if (Tcl_GetInt(interp,xargv[1],&damattH) != TCL_OK)
				return(TCL_ERROR);
			free (xargv);
		} else damattH = damattL;
		/* argv[16] specialatt */
		/* argv[17] specialdef */
		if (Tcl_GetInt(interp,argv[18],&mr) != TCL_OK)
			return(TCL_ERROR);
		IntelligenceRating i = IntelligenceRating(argv[19]);
		if (!i)
		{
			Tcl_AppendResult(interp, "Bad intelligence word: ",
					 argv[19],"should be one of {",
					 "Non Animal Semi Low Average Very ",
					 "Highly Exceptionally Genius ",
					 "Supra-Genius Godlike}",
					 (char*) NULL);
			return TCL_ERROR;
		}
		/* argv[20] alignment */
		double s;
		if (Tcl_GetDouble(interp,argv[21],&s) != TCL_OK)
			return TCL_ERROR;
		/* argv[22] psionics */
		/* argv[23] comments */
		monster = new Monster(hd,nd,armorclass,move,fly,swim,burrow,web,
				      percentinlair,numatt,damattL,damattH,mr,
				      noappearL,noappearH,
				      i,f,s,argv[1],argv[20],argv[13],
				      argv[16],argv[17],argv[22],argv[23]);
	}
	char handle[32];
	Monster ** h = (Monster**) Tcl_HandleAlloc (Monster::Handles,handle);
	*h = monster;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)monsterCommand,
			  (ClientData)monster,
			  (Tcl_CmdDeleteProc*)deleteMonster);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allMonsters(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(Monster::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(Monster::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

static int findMonstersBy(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	int walk;
	enum {name, treasure, alignment} field;
	Monster **mp;
	if (argc != 3)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?{name treasure alignment} pattern? \"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1],"name") == 0) field = name;
	else if (strcmp(argv[1],"treasure") == 0) field = treasure;
	else if (strcmp(argv[1],"alignment") == 0) field = alignment;
	else
	{
		Tcl_AppendResult(interp, "Bad field name: ",argv[1],
				 "should be one of {name treasure alignment}",
				 (char*) NULL);
		 return TCL_ERROR;
	}
	walk = -1;
	while ((mp = (Monster**) Tcl_HandleWalk(Monster::Handles,&walk)) != NULL)
	{
		Monster *m = *mp;
		String value;
		switch (field)
		{
			case name:	value = m->Name; break;
			case treasure:	value = m->TreasureType; break;
			case alignment:	value = m->Alignment; break;
		}
		if (Tcl_StringMatch((char*)value,argv[2]))
		{
			char handle[32];
			Tcl_WalkKeyToHandle(Monster::Handles,walk,handle);
			Tcl_AppendElement(interp,handle);
		}
	}
	return TCL_OK;
}


int Monster_Init(Tcl_Interp *interp)
{
	Monster::Handles = Tcl_HandleTblInit("Monster",sizeof(Monster*),256);
	Tcl_CreateCommand(interp, "Monster", (Tcl_CmdProc*)monsterCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllMonsters", (Tcl_CmdProc*)allMonsters,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "FindMonstersBy", (Tcl_CmdProc*)findMonstersBy,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

