/* $Id: tf.connect.c,v 30000.24 1993/05/25 01:07:32 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/


/****************************************************************
 * Fugue connection process                                     *
 * Written by Ken Keys.                                         *
 * arguments:  <hostname> <port> <stream pipe fd number>        *
 * This program should be exec'ed by tf to open connections to  *
 * worlds.  It will pass the open descriptor back through a     *
 * "stream pipe".                                               *
 ****************************************************************/

#ifdef USE_STRING_H
# include <string.h>
#endif
#ifdef USE_STRINGS_H
# include <strings.h>
# define memcpy(dst, src, len) bcopy((src), (dst), (len))
#endif

#include <signal.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netdb.h>
#ifdef WINS
# include <sys/in.h>
# include <sys/inet.h>
#else
# include <netinet/in.h>
#endif

#include "port.h"

#ifdef CONNECT_SVR4
# include <stropts.h>
#endif
#ifdef CONNECT_BSD
# include <sys/uio.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif
#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif
#include "tf.connect.h"
#include "opensock.h"

#ifndef NULL
# define NULL 0
#endif

extern int errno;

static int FDECL(sendfd,(int sockfd, int fd));
int FDECL(main,(int argc, char **argv));

static int sendfd(sockfd, fd)
    int sockfd, fd;
{
#ifdef CONNECT_SVR4
    return ioctl(sockfd, I_SENDFD, fd);
#endif

#ifdef CONNECT_BSD
    struct iovec iov[1];
    struct msghdr msg;
# ifdef CONNECT_BSD44                           /* BSD 4.3 Reno or later */
    struct cmsghdr cmptr[1];
# endif

    iov[0].iov_base = NULL;
    iov[0].iov_len = 0;
    msg.msg_name = NULL;
    msg.msg_namelen = 0;
    msg.msg_iov = iov;
    msg.msg_iovlen = 1;
# ifdef CONNECT_BSD44                           /* BSD 4.3 Reno or later */
    cmptr->cmsg_level = SOL_SOCKET;
    cmptr->cmsg_type = SCM_RIGHTS;
    cmptr->cmsg_len = CONTROLLEN;
    msg.msg_control = (caddr_t)cmptr;
    msg.msg_controllen = CONTROLLEN;
    *(int*)CMSG_DATA(cmptr) = fd;
    return (sendmsg(sockfd, &msg, 0));
# else                                       /* vanilla 4.3 BSD */
    msg.msg_accrights = (char*) &fd;
    msg.msg_accrightslen = sizeof(fd);
    return (sendmsg(sockfd, &msg, 0));
# endif
#endif
}

int main(argc, argv)
    int argc;
    char *argv[];
{
    int tfcerrno = TFC_OK, fd, sockfd;
    struct sockaddr_in addr;

    signal(SIGINT, SIG_IGN);
    close(0);
    close(1);
    close(2);

    sockfd = atoi(argv[3]);
    if ((fd = open_sock(argv[1], argv[2], &addr, &tfcerrno)) >= 0) {
        if (connect(fd, (struct sockaddr*)&addr, sizeof(addr)) < 0) {
            close(fd);
            tfcerrno = TFC_ECONNECT;
        }
    }
    send(sockfd, &tfcerrno, sizeof(tfcerrno), 0);
    if (tfcerrno == TFC_OK) sendfd(sockfd, fd);
    else send(sockfd, &errno, sizeof(errno), 0);
    return 0;
}

