/* $Id: special.c,v 30000.21 1993/05/18 08:58:11 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/


/**********************************************************************
 * Fugue filtering functions                                          *
 *                                                                    *
 * Written by Greg Hudson and Ken Keys.                               *
 * Triggers, portals, watchdog, and quiet login are all handled here. *
 **********************************************************************/

#include <ctype.h>
#include "port.h"
#include "tf.h"
#include "util.h"
#include "world.h"
#include "socket.h"
#include "macro.h"
#include "history.h"

static int  FDECL(keep_quiet,(char *what, short *count));
static int  FDECL(handle_portal,(char *what));

short FDECL(special_hook,(struct History *hist, char *what, short *count));

static int keep_quiet(what, count)
    char *what;
    short *count;
{
    if (!*count) return FALSE;
    if (!cstrncmp(what, "Use the WHO command", 19) ||
      !cstrncmp(what, "### end of messages ###", 23)) {
        *count = 0;
    } else (*count)--;
    return TRUE;
}

short special_hook(hist, what, count)
    struct History *hist;
    char *what;
    short *count;
{
    short attr = 0;

    if ((attr = check_trigger(what)) & F_GAG && gag)
        return attr & F_SUPERGAG;
    if (keep_quiet(what, count)) return F_GAG;
    if (is_suppressed(hist, what)) return F_GAG;
    if (handle_portal(what)) return F_GAG;
    return attr;
}

static int handle_portal(what)
    char *what;
{
    smallstr name, address, port;
    char *buffer, *place;
    World *world;

    if (!bamf) return(0);
    if (sscanf(what, "#### Please reconnect to %64s (%64[^ )]) port %64s ####",
		 name, address, port) != 3) return 0;
#ifdef RESTRICT_WORLD
    tfputs("% bamfing is restricted.", tferr);
    return 0;
#else
    place = strchr(name, '@');              /* Get IP address. */
    if (place == NULL) return (0);
    *place++ = '\0';

    if (bamf != 2) {
        buffer = (char *)MALLOC(strlen(name) + 2);
        *buffer = '@';
        strcpy(buffer + 1, name);
        world = fworld();
        world = new_world(buffer, world->character, world->pass,
            (isdigit(*place) ? place : address), port, world->mfile);
        FREE(buffer);
        world->flags |= WORLD_TEMP;
    } else if (!(world = find_world(name))) {
        world = new_world(name, "", "", isdigit(*place) ? place : address,
            port, "");
        world->flags |= WORLD_TEMP;
    }

    do_hook(H_BAMF, "%% Bamfing to %s", "%s", name);
    if (bamf != 2) disconnect("");
    if (!connect_to(world, TRUE))
        tfputs("% Connection through portal failed.", tferr);
    return 1;
#endif
}
