/* $Id: port.h,v 30000.2 1993/05/25 01:05:04 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef PORT_H
#define PORT_H

#ifdef hpux
# define _HPUX_SOURCE     /* Needed for stat() (and maybe others) on hpux 7.0 */
#endif

#ifndef _ALL_SOURCE
# define _ALL_SOURCE      /* Enables some "extensions" on AIX. */
#endif

#include "prototype.h"

/* standard stuff */
#include <stdio.h>
#if __STDC__ - 0
# define HAVE_STDARG
#endif

#if __STDC__ - 0
# define GENERIC void
# define CONST   const
#else
# define GENERIC char
# define CONST
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#else
extern void free();
#endif

#ifndef RANDOM             /* True only if Build couldn't find it in libc.a. */
# define RANDOM rand       /* This is guaranteed to exist under ANSI. */
# define SRANDOM srand
#endif

/* This works if you cast all time_t's to TIME_T. */
# define TIME_T         long

#define TRUE 1
#define FALSE 0

#endif /* PORT_H */
