/* $Id: makehelp.c,v 30000.22 1993/05/25 01:12:32 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/


/**************************************************************
 * Fugue help index builder                                   *
 *                                                            *
 * Algorithm developed by Leo Plotkin.  Rewritten by Ken Keys *
 * to be self-contained and build index at install time.      *
 **************************************************************/

#include <stdio.h>
#include "port.h"

#ifdef HAVE_STDLIB_H
# include <stdlib.h>
#endif

#ifdef HAVE_UNISTD_H
# include <unistd.h>
#endif

#ifdef USE_STRING_H
# include <string.h>
#endif
#ifdef USE_STRINGS_H
# include <strings.h>
#endif

#define HELPFILE "tf.help"
#define INDEXFILE "tf.help.index"

int FDECL(main,(int argc, char **argv));

int main(argc, argv) 
    int argc;
    char **argv;
{
    char line[81];
    FILE *indexfile, *helpfile;
    unsigned charcount = 0;

    if ((helpfile = fopen(HELPFILE, "r")) == NULL) {
        printf("%% File %s cannot be opened for reading.\n", HELPFILE);
        return 1;
    }
    if ((indexfile = fopen(INDEXFILE, "w")) == NULL) {
        printf("%% File %s cannot be opened for writing.\n", INDEXFILE);
        return 1;
    }
    while (fgets(line, 80, helpfile) != NULL) {
        if (!strncmp(line, "@@@@", 4))
            fprintf(indexfile, "%u:%s", charcount, line + 4);
        charcount += strlen(line);
    }
    fclose(indexfile);
    fclose(helpfile);
    return 0;
}
