/* config.h */

#ifndef __CONFIG_H
#define __CONFIG_H

#include "version.h"
#include "copyright.h"
#include "options.h"


/*----- Miscellaneous other stuff -----*/

#define God(x)  ((x) == GOD)

/* limit on player name length */
#define PLAYER_NAME_LIMIT 16

/* magic cookies */
#define LOOKUP_TOKEN '*'
#define NUMBER_TOKEN '#'
#define ARG_DELIMITER '='

/* magic command cookies */
#define SAY_TOKEN '"'
#define POSE_TOKEN ':'
#define SEMI_POSE_TOKEN ';'
#define CHAT_TOKEN '+'

/* delimiter for lists of exit aliases */
#define EXIT_DELIMITER ';'

#define OBJECT_ENDOWMENT(cost) (((cost)-5)/5)

/* !!! added for recycling, return value of object */
#ifdef DESTROY
#define OBJECT_DEPOSIT(pennies) ((pennies)*5+5)
#endif /* DESTROY */

#define QUIT_COMMAND "QUIT"
#define WHO_COMMAND "WHO"
#define LOGOUT_COMMAND "LOGOUT"

#ifdef AT_DOING
#define DOING_COMMAND "DOING"
#endif

#ifdef RWHO_SEND
#ifdef FULL_RWHO
#define RWHO_COMMAND "RWHO"
#endif 
#endif

#define PREFIX_COMMAND "OUTPUTPREFIX"
#define SUFFIX_COMMAND "OUTPUTSUFFIX"

/*----- interface.c stuff -----*/

#ifdef XENIX
#define MAX_INPUT 4096		/* only used in xenix.c */
#endif
#define MAX_OUTPUT 16384
#define COMMAND_TIME_MSEC 1000	/* time slice length in milliseconds */
#define COMMAND_BURST_SIZE 100	/* commands allowed per user in a burst */
#define COMMANDS_PER_TIME 1	/* commands per time slice after burst */

#ifdef BRAIN_DAMAGE		/* a kludge to get it to work on a mutant
				 * DENIX system */
#undef toupper
#endif

/* ---  DO NOT CHANGE ANYTHING BELOW THIS LINE --- */

typedef struct fblock_header FBLKHDR;
typedef struct filecache_block FBLOCK;

#define FBLOCK_SIZE (256 - sizeof(FBLKHDR))

struct fblock_header {
  FBLOCK *nxt;
  int nchars;
};

struct filecache_block {
  FBLKHDR hdr;
  char data[FBLOCK_SIZE];
};

typedef struct options_table OPTTAB;

struct options_table {
  char mud_name[128];
  int port;
  char input_db[256];
  char output_db[256];
  char crash_db[256];	
  char mail_db[256];
  int guest_player;
  int player_start;
  int master_room;
  int idle_timeout;
  int dump_interval;
  int dump_counter;
  int max_logins;
  int paycheck;
  int starting_money;
  int player_queue_limit;
  char money_singular[32];
  char money_plural[32];
  char compress[256];
  char uncompress[256];
  char help_file[256];
  char help_index[256];
  char news_file[256];
  char news_index[256];
  char events_file[256];
  char events_index[256];
  char connect_file[256];
  char motd_file[256];
  char wizmotd_file[256];
  char newuser_file[256];
  char register_file[256];
  char quit_file[256];
  char down_file[256];
  char full_file[256];
  FBLOCK *connect_fcache;
  FBLOCK *motd_fcache;
  FBLOCK *wizmotd_fcache;
  FBLOCK *newuser_fcache;
  FBLOCK *register_fcache;
  FBLOCK *quit_fcache;
  FBLOCK *down_fcache;
  FBLOCK *full_fcache;
  int log_commands;
  int log_huhs;
  int log_forces;
  int log_walls;
  int login_allow;
  int daytime;
  int player_flags;
  int room_flags;
  int exit_flags;
  int thing_flags;
  int player_toggles;
  int room_toggles;
  int exit_toggles;
  int thing_toggles;
  int rwho_interval;
  int rwho_counter;
  int rwho_port;
  char rwho_host[64];
  char rwho_pass[64];
};

extern OPTTAB options;

#define DUMP_INTERVAL       (options.dump_interval)
#define INACTIVITY_LIMIT    (options.idle_timeout)

#ifdef LOGIN_LIMIT
#define MAX_LOGINS      (options.max_logins)
#endif

#define  HELPTEXT	(options.help_file)
#define  HELPINDX	(options.help_index)

#define  NEWS_FILE      (options.news_file)
#define  NEWSINDX       (options.news_index)

#ifdef EVENTS
#define EVENT_FILE            (options.events_file)
#define EVENTINDX             (options.events_index)
#endif

/* dbrefs are in the conf file */

#ifndef GUEST_RESTRICT
#define Guest(x) (0)
#else
#define GUEST_PLAYER   (options.guest_player)
#define Guest(x) ((x) == GUEST_PLAYER)
#endif

#define TINYPORT         (options.port)
#define PLAYER_START     (options.player_start)
#define MASTER_ROOM      (options.master_room)
#define MONEY            (options.money_singular)
#define MONIES           (options.money_plural)

#define START_BONUS      (options.starting_money)
#define PAY_CHECK        (options.paycheck)

#define QUEUE_QUOTA      (options.player_queue_limit)

#define MUDNAME          (options.mud_name)
#define DEF_DB_IN	 (options.input_db)
#define DEF_DB_OUT	 (options.output_db)

#ifdef RWHO_SEND
#define RWHO_INTERVAL    (options.rwho_interval)
#define RWHOSERV         (options.rwho_host)
#define RWHOPORT         (options.rwho_port)
#define RWHOPASS         (options.rwho_pass)
#endif

#endif /* __OPTIONS_H */
