/*
    passwords.c  Password handlers for cheezmud.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdio.h>
#include <unistd.h>
#include <assert.h>

void
delete_user (char *user)
{
  FILE *fin, *fout;
  char buf[80], buf2[80];
  assert (!(rename ("etc/passwd", "etc/passwd~")));
  assert (fin = fopen ("etc/passwd~", "r"));
  assert (fout = fopen ("etc/passwd", "w"));
  while (fgets (buf, 80, fin))
  {
    assert (sscanf (buf, "%s", buf2) == 1);
    if (strcmp (buf2, user))
      fputs (buf, fout);
  }
  fclose (fin);
  fclose (fout);
}

void
add_user (char *user, char *password)
{
  FILE *fp;
  assert (fp = fopen ("etc/passwd", "a"));
  fprintf (fp, "%s %s\n", user, password);
  fclose (fp);
}

void
set_password (char *user, char *password)
{
  delete_user (user);
  add_user (user, password);
}
