/*
    Start.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Start

- init
{
  [super init];
  [self describe: "start": "Information Booth": "Information Booth":
    "This is a help center, where clues are supposed to be politely distributed by\n\
a full-time consultant.  There is a big sign here that says TAKE ONE, apparently\n\
in reference to the pile of GPLs on the floor.  To the south is the main part\n\
of the Tech Center.  The outside world lies to the north."];
  return self;
}

//  The heartbeat for the start room does global things that have no place
//  specific to be done.
- (void) heartbeat
{
  int count=0, lcount=0, ccount=0, gcount=0, pagecount=0, t1, t2,
    countflag=0, knightcount=0, spidercount=0;
  void countGPL (id whatever)
  {
    if ([whatever isKindOf: [GPL class]])
      count++;
  }
  void countetc (id whatever)
  {
    if ([whatever isKindOf: [Lightbug class]])
      lcount++;
    else if ([whatever isKindOf: [Shotgundude class]])
      gcount++;
    else if ([whatever isKindOf: [Chaingundude class]])
      ccount++;
    else if ([whatever isKindOf: [Page class]])
      pagecount++;
    else if ([whatever isKindOf: [Knight class]])
      knightcount++;
    else if ([whatever isKindOf: [Spider class]])
      spidercount++;
  }

  //  Keep the pile of GPLs stocked.
  [contents withObjectsCall: countGPL];
  if (count < 3)
    [[GPL new] setlocation: self];

  beatcount++;
  t1 = beatcount % 4800;   /* 20 min cycle */
  t2 = beatcount % 10800;  /* 45 min cycle */
  /* Least common multiple = 43200 */

  if (!t1) {
    if (!countflag) {
      countflag = 1;
      [world withObjectsCall: countetc];
    }
    if (lcount < 2) {
      id c = global_find ("culdesac2", 1);
      [[Lightbug new] setlocation: c];
      [c echo:
      "A little firefly crawls out of the grass and starts flying around."];
    }
    if (pagecount < 4) {
      id c = global_find ("imp1a", 1);
      [[Page new] setlocation: c];
      [c echo: "The page arrives."];
    }
    if (knightcount < 4) {
      id c = global_find ("imp3a", 1);
      [[Knight new] setlocation: c];
      [c echo: "The knight arrives."];
    }
    if (!spidercount) {
      [[Spider new] setlocation: global_find ("underfloor", 1)];
    }
  }

  if (!t2) {
    if (!countflag) {
      countflag = 1;
      [world withObjectsCall: countetc];
    }
    if (!ccount) {
      id c = global_find ("doom1", 1);
      [[Chaingundude new] setlocation: c];
      [c echo: "The commando arrives."];
    }
    if (!gcount) {
      id c = global_find ("doom1", 1);
      [[Shotgundude new] setlocation: c];
      [c echo: "The guerrilla arrives."];
    }
  }

  if (!(t1 || t2))
    beatcount = 0;
}

@end
