/*
    Mudobject.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Mudobject

- init
{
  [super init];
  beatcount = dead = loggedout = audit = 0;
  [world addElement: self];
  mudname = strdup ("object");
  indef = strdup ("an object");
  def = strdup ("the object");
  longdesc = strdup ("It is just a plain object, without any distinguishing\
 feature.");
  return self;
}

- free
{
  free (mudname);
  free (longdesc);
  free (indef);
  free (def);
  return [super free];
}

- logout
{
  if (!loggedout) {
    //  I absolutely *hate* this, but there isn't much alternative.
    [world safeMakeObjectsPerform: @selector(clue:) with: self];
    dead = loggedout = 1;
    push_death (self);  // Add to list of things to free later
  }
  return self;
}

- (float) priority: (char *) action: (int) numargs
{
  // Not supported
  return -1.0;
}

- describe: (char *) newname: (char *) newindef: (char *) newdef:
  (char *) newlongdesc;
{
  [[[[self setmudname: newname] setindef: newindef]
    setdef: newdef] setlongdesc: newlongdesc];
  return self;
}

- setmudname: (char *) newname
{
  assert (newname);
  free (mudname);
  mudname = strdup (newname);
  return self;
}

- setindef: (char *) newdesc
{
  assert (newdesc);
  free (indef);
  indef = strdup (newdesc);
  return self;
}

- setdef: (char *) newdesc
{
  assert (newdesc);
  free (def);
  def = strdup (newdesc);
  return self;
}

- setlongdesc: (char *) newdesc
{
  assert (newdesc);
  free (longdesc);
  longdesc = strdup (newdesc);
  return self;
}

- (char *) mudname
{
  return mudname;
}

- (char *) longdesc
{
  return longdesc;
}

- (char *) indef
{
  return indef;
}

- (char *) def
{
  return def;
}

- echo: (char *) text
{
  if (audit) {
    id ma;
    if (!(ma = global_find (mudadmin, 1))) {
      [self toggle_audit];
      return self;
    }
    text_sock_write ([ma getty], def);
    text_sock_write ([ma getty], " echo:  ");
    text_sock_write ([ma getty], text);
    text_sock_write ([ma getty], "\n");
  }

  // Most objects ignore echos
  return self;
}

- emote: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion
{
  return self;
}

- emote: emoter: (char *) verb_you: (char *) verb_he: dobj: (char *) emotion
{
  return self;
}

- say: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion
{
  return [self emote: emoter: verb_you: verb_he: emotion];
}

- (void) heartbeat
{
  ;
}

- listcontents: who
{
  return self;
}

- clue: dontkillme
{
  return self;
}

- (int) isdead
{
  return dead;
}

- toggle_audit
{
  audit = 1 - audit;
}

@end
