/*
    Mina_shrine.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Mina_shrine

- init
{
  [super init];
  [self describe: "imp0": "Stairwell": "Stairwell":
"You are at the bottom of the stairwell of a small castle that houses the\n\
imperial offices of this locality.  The stairs come to an abrupt end in\n\
a dusty little alcove with no obvious exit other than to go back up the\n\
stairs.  The alcove contains a shrine to Mina, the Martyr for Beating a Hasty\n\
Retreat from Really Nasty Things.  The shrine depicts a petite female in solemn\n\
prayer as a gang of really nasty barbarians approaches."];
  return self;
}

- (float) priority: (char *) action: (int) numargs
{
  if (numargs == 1) {
    if (!strcmp (action, "pray"))
      return 10.0;
  }
  return [super priority: action: numargs];
}

- pray: who
{
  [[who getlocation] emote: who: "kneel": "kneels": " in prayer to Mina"];
  // Silent teleport
  [who setlocation: global_find ("middleroad", 1)];
  return self;
}

@end
