/*
    Lightbug.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Lightbug

- init
{
  [super init];
  [self describe: "firefly": "a firefly": "the firefly":
    "It is just a harmless little firefly, looking for a mate."];
  beatcount = random() % 1000;
  return self;
}

- (void) heartbeat
{
  int t1, t2;
  if (dead)
    return;
  beatcount++;
  t1 = beatcount % 47;
  t2 = beatcount % 203;
  if (!t1)
    [location emote: self: "flash": "flashes": ""];
  if (!t2)
    [self runaway];
  if (!(t1 || t2))
    beatcount = 0;
}

- hit: fromwho: (float) damage
{
  if (dead)
    return self;
  dead = 1;
  [location emote: self: "die": "dies": ""];
  [[[Corpse new] describe: "firefly": "a dead firefly": "the dead firefly":
    "It's a poor little dead firefly that some nasty person killed."]
    setlocation: location];
  [self logout];
  return self;
}

- runaway
{
  int result, choice, loop;
  id e;
  if (!location)
    return self;
  if (![location isKindOf: [Room class]])
    return self;
  for (loop=0;loop<12;loop++) {
    choice = random() % 6;
    result = 0;
    switch (choice) {
    case 0:
      result = [self do: "n"];
      break;
    case 1:
      result = [self do: "s"];
      break;
    case 2:
      result = [self do: "w"];
      break;
    case 3:
      e = [location dirquery: 'e'];
      if (!e)
        break;
      if (strncmp ([e mudname], "doom", 4))
        result = [self do: "e"];
      break;
    case 4:
      result = [self do: "u"];
      break;
    case 5:
      result = [self do: "d"];
      break;
    default:
      assert (0);
    }
    if (result)
      return self;
  }
  return self;
}

@end
