/*
    Darkroom.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Darkroom

- init
{
  [super init];
  darkindef = strdup ("a dark place");
  darkdef = strdup ("the dark place");
  darklongdesc = strdup ("It is too dark to see anything in here.");
  return self;
}

- setdarkindef: (char *) newdesc
{
  assert (newdesc);
  free (darkindef);
  darkindef = strdup (newdesc);
  return self;
}

- setdarkdef: (char *) newdesc
{
  assert (newdesc);
  free (darkdef);
  darkdef = strdup (newdesc);
  return self;
}

- setdarklongdesc: (char *) newdesc
{
  assert (newdesc);
  free (darklongdesc);
  darklongdesc = strdup (newdesc);
  return self;
}

- free
{
  free (darklongdesc);
  free (darkindef);
  free (darkdef);
  return [super free];
}

//  Light must be in the room or carried by a fighter.
- (int) islighted
{
  BOOL flag = YES;
  void doIt (id whatever)
  {
    void doItDeeper (id what)
    {
      if ([what isKindOf: [Light class]]) {
        flag = NO;
        return;
      }
    }
    if ([whatever isKindOf: [Light class]]) {
      flag = NO;
      return;
    }
    if ([whatever isKindOf: [Fighter class]]) {
      [[whatever contents] withObjectsCall:doItDeeper whileTrue:&flag];
    }
  }
  [[self contents] withObjectsCall:doIt whileTrue:&flag];
  if (flag == NO)
    return 1;
  return 0;
}

- (char *) longdesc
{
  if ([self islighted])
    return longdesc;
  else
    return darklongdesc;
}

- (char *) indef
{
  if ([self islighted])
    return indef;
  else
    return darkindef;
}

- (char *) def
{
  if ([self islighted])
    return def;
  else
    return darkdef;
}

- listcontents: who
{
  if (![self islighted])
    return self;
  return [super listcontents: who];
}

@end
