/*
    deathstack.c  Stupid workaround for cheezmud.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdlib.h>
#include <assert.h>

/* This code was added to avoid the need to free objects that are in */
/* world while traversing world (which is extremely bad luck).       */

struct death_elm {
  void *elm;
  struct death_elm *next;
};

struct death_elm *list_of_death = NULL;

void
push_death (void *deadone)
{
  struct death_elm *t;
  assert (t = malloc (sizeof (struct death_elm)));
  t->next = list_of_death;
  t->elm = deadone;
  list_of_death = t;
}

void *
pop_death ()
{
  struct death_elm *t;
  void *u;
  t = list_of_death;
  if (!t)
    return NULL;
  list_of_death = t->next;
  u = t->elm;
  free (t);
  return u;
}
