/*
    cheezmud.h  Common declarations for cheezmud sources.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* cheezmud.h  Common declarations for cheezmud sources.
 * DWF  1/26/95
 */

/* Standard includes */
#include <stdio.h>
#include <math.h>
#include <string.h>
#include <assert.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <objects/Bag.h>
#include "Mudadmin.h"
#include "Darkroom.h"
#include "Start.h"
#include "TechCenter.h"
#include "Spider.h"
#include "Bee.h"
#include "Corpse.h"
#include "GPL.h"
#include "Idiot.h"
#include "Sack.h"
#include "Radio.h"
#include "Lightbug.h"
#include "Doomroom.h"
#include "Chaingundude.h"
#include "Shotgundude.h"
#include "Mina_shrine.h"
#include "Page.h"
#include "Bob.h"
#include "Knight.h"
#include "Imp_Office.h"
#include "Queen.h"
#include "King.h"

/* Version */
#define version "Cheezmud 1.0 (Beta #1)"

/* Who is the mud admin? */
#define mudadmin "Dave"

/* Port to use */
#define inport_number 2000

/* Collection of all mud objects */
extern id world;

/* Number of microseconds between heartbeats */
#define heartbeat_microseconds 250000

/* Time of last heartbeat */
extern struct timeval lastheartbeat;

extern void
service_cons ();
extern void
powerup ();
extern void
wait_for_activity ();
extern void
text_sock_write ();
extern void
delmark ();
extern void
genesis ();
extern id
global_find (char *, int);
extern id
generic_find (id, char *, int);
extern id
generic_find_creturn (id, char *, int *);
extern id
generic_find_cascade (id, id, char *, int);
extern char *
noeol ();
extern void
show_users ();
extern long
timesincelastheartbeat ();
extern void
do_heartbeats ();
extern char *
capitalize ();
extern int
global_number (char *, id);
extern int
generic_number (id, char *, id);
extern int
generic_number_cascade (id, id, char *, id);
extern id
get_random_member (id);
extern void
push_death (void *);
extern void *
pop_death ();
extern void
de_notify ();
extern void
echo_text_file (id, char *);
extern void
delete_user (char *);
extern void
set_password (char *, char *);
extern void
cheezlog (char *);
extern void
checkpoint ();
