/*
    Sack.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Sack

- init
{
  [super init];
  [self describe: "sack": "a sack": "the sack":
    "This is a burlap bag.  You can bag or unbag things."];
  return self;
}

- (float) priority: (char *) action: (int) numargs
{
  if (numargs == 2) {
    if (!strcmp (action, "bag")) {
      if ([contents count] >= capacity)
        return -1;
      return 20.0 * (float)(capacity - [contents count]) / (float)capacity;
    }
  }
  return [super priority: action: numargs];
}

- bag: who: dobj
{
  if (dobj == self) {
    [who echo: "You can't put a bag inside itself."];
    return self;
  }
  [[who getlocation] emote: who: "bag": "bags": dobj: ""];
  [dobj setlocation: self];
  return self;
}

@end
