/*
    Doomroom.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

static long int snum = 0;

@implementation Doomroom

- init
{
  id victim;
  char dir1[] = "nsewud", dir2[] = "snwedu", tname[20];
  [super init];
  sprintf (tname, "doom%ld", snum);
  [self describe: tname:
               "Temple of Doom":
               "Temple of Doom":
      "You are in a twisty little maze of video games, all alike."];

  //  Link up!
  if (!snum) {
    assert (victim = global_find ("underfloor", 1));
    [self setexit: "w": victim];
    [victim setexit: "e": self];
  }
  else {
    int dr, looper, v;
    v = (random() % 3) + 1;
    for (looper=0;looper<v;looper++) {
      do {
        sprintf (tname, "doom%ld", random() % snum);
        assert (victim = global_find (tname, 1));
        dr = random() % 6;
      } while ([victim dirquery: dir2[dr]] || [self dirquery: dir1[dr]]);
      assert (victim != self);
      [self setexit: &(dir1[dr]): victim];
      [victim setexit: &(dir2[dr]): self];
    }
  }
  snum++;

  return self;
}

- (char *) longdesc
{
  static char dd[160];
  sprintf (dd, "%s\nExits: ", longdesc);
  if (n)
    strcat (dd, " n");
  if (s)
    strcat (dd, " s");
  if (e)
    strcat (dd, " e");
  if (w)
    strcat (dd, " w");
  if (u)
    strcat (dd, " u");
  if (d)
    strcat (dd, " d");
  return dd;
}

@end
