/*
    Bee.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Bee

- init
{
  [super init];
  [self describe: "bee": "a bumble-bee": "the bumble-bee":
    "This bee is BIG.  If it crashed into you it might knock you over."];
  return self;
}

- (void) heartbeat
{
  if (dead)
    return;
  beatcount++;
  if (beatcount == 80)
    [location emote: self: "buzz": "buzzes": " around"];
  if (beatcount == 90)
    [location emote: self: "buzz": "buzzes": " around"];
  if (beatcount == 100) {
    beatcount = 0;
    [location emote: self: "land": "lands": " on a pepper blossom"];
  }
}

- hit: fromwho: (float) damage
{
  if (dead)
    return self;
  [fromwho clue: self];
  [location emote: self: "dodge the blow and sting":
    "dodges the blow and stings": fromwho: " right between the eyes"];
  return self;
}

@end
