
#include <stdio.h>

/* Register indices into mode state array. */

#define VGA_CRTC_OFFSET		0	/* 24 registers */
#define VGA_ATC_OFFSET		24	/* 21 registers */
#define VGA_GRAPHICS_OFFSET	45	/* 9 registers. */
#define VGA_SEQUENCER_OFFSET	54	/* 5 registers. */
#define VGA_MISCOUTPUT		59	/* (single register) */
#define VGA_TOTAL_REGS		60

struct {
	int offset;
	char *label;
	} labels[] = {
		{ VGA_CRTC_OFFSET, "CRTC" },
		{ VGA_ATC_OFFSET, "ATC" },
		{ VGA_GRAPHICS_OFFSET, "GRAPHICS" },
		{ VGA_SEQUENCER_OFFSET, "SEQUENCER" },
		{ VGA_MISCOUTPUT, "MISCOUTPUT" },
		{ 0, NULL }
	};


char *printbits(unsigned char value)
{
	static char bits[9];
	int i;

	for ( i=0; i<8; ++i )
		bits[i] = ( (value & 0x80>>i) ? '1' : '0' );
	bits[i] = '\0';
	return(bits);
}

main(int argc, char *argv[])
{
	int i, k, l;
	FILE *f1, *f2;
	unsigned char regs1[VGA_TOTAL_REGS], regs2[VGA_TOTAL_REGS];

	if ( argc != 3 ) {
		fprintf(stderr, "Usage: %s <regs1> <regs2>\n", argv[0]);
		exit(1);
	}

	if ( !(f1=fopen(argv[1], "r")) || !(f2=fopen(argv[2], "r")) ) {
		perror("Can't open arguments for reading");
		exit(3);
	}
	if ( !fread(regs1, VGA_TOTAL_REGS, 1, f1) ||
	     !fread(regs2, VGA_TOTAL_REGS, 1, f2) ) {
		perror("Can't read registers from input files");
		exit(3);
	}
	fclose(f1); fclose(f2);

	printf("Register Name			%s		%s\n",
							argv[1], argv[2]);
	for ( i=0; i<VGA_TOTAL_REGS; ++i ) {
		if ( regs1[i] != regs2[i] ) {
			printf("Reg data offset: %d\n", i);
			for ( k=0; k<VGA_TOTAL_REGS; ++k ) {
				for ( l=0; labels[l].label; ++l ) {
					if ( k <= labels[l].offset )
						goto print_diff;
				}
			}
		print_diff:
			printf(
"VGA bank %s (index 0x%X):	%s (0x%.2X)	",
				labels[l].label, (char)(i-labels[l].offset), 
						printbits(regs1[i]), regs1[i]);
			printf("%s (0x%.2X)\n", printbits(regs2[i]), regs2[i]);
		}
	}
	exit(0);
}
