// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Function prototypes for print.cpp
void  Getframename(int framenum, char *string);
int   Getinput(int x, int y, char *string, int maxlen, int type);
void  Getsoundname(int soundnum, char *string);
void  Getspritename(int spritenum, char *string);
int   Gettextnum(int offset);
void  Getthingname(int thingnum, char *string);
void  Highlightname(char *name);
void  Printammo(void);
void  Printframe(void);
void  Printhelp(void);
void  Printintro(void);
void  Printoptions(void);
void  Printsound(void);
void  Printsprite(void);
void  Printtext(void);
void  Printtextintro(void);
void  Printthing(void);
void  Printthingbits(void);
void  Printthingframe(void);
void  Printthinginfo(void);
void  Printthinglist(void);
void  Printthingmisc(void);
void  Printthingsound(void);
EBool Printwindow(char *message, int type);

// Array of pointers to update functions
typedef void (*vfuncptr)();
vfuncptr Printfunc[NUMSCREENS] = {Printthing, Printframe, Printammo,
											 Printsound, Printsprite, Printtext,
											 Printthinglist};

// This is an offset to be used for computing the text stuff.
long toff[NUMVERS] = {0, 129044L, 129044L, 129284L, -1024L, -1024L, 268557520L};

char *up_arrows[2] = { "^", "" };
char *down_arrows[2] = { "v", "" };

// Functions from screen.cpp
extern void CPrintfXY(int x, int y, char *string, ...);
extern void CPutsXY(int x, int y, char *string);
extern void Drawframe(int type, unsigned char attr, int left, int top,
							 int right, int bot);

// Variables from dehacked.cpp
extern ERedraw redraw;						//	Current redraw state
extern EModes  mode;							//	The mode we start in
extern EVersions version;   	         // The Doom version we're using
extern ETruever  truever;					// The "real" Doom version we're using
extern int  global[NUMSCREENS][5];		// Global data array
extern char thingorder[THING_FIELDS];
extern int  numobj[NUMDATA][NUMVERS];	// Number of objects for dif version
extern char doomexe[80];					// Doom.exe file name
extern char doomwad[80];					// Doom.wad file name
extern char patchdir[80];					// Patch file directory
extern EBool batch;							// If we're running in batch mode

extern unsigned long (*thingdata )[THING_FIELDS];
extern unsigned long (*framedata )[FRAME_FIELDS];
extern unsigned long (*sounddata )[SOUND_FIELDS];
extern unsigned long (*weapondata)[WEAPON_FIELDS];
extern unsigned long *spritedata;
extern unsigned long *maxammodata;
extern unsigned long *perammodata;
extern char *textdatap;
extern struct sb_conf dev;

extern const int size[NUMDATA][NUMVERS];

// Functions from dehacked.cpp
extern void AbortProg(char *func);

// Variables from files.h
extern unsigned char thingconvar[104];			// Thing # conversion array

// Functions from input.h
extern int Getinput(int promptlen, char *string, int maxlen, int type, int x1);
extern int Printinputwindow(char *buffer, char *prompt, EInptype type, int length);
extern EBool Waitforevent(EBool eatevent);

// Variables from input.h
extern int arrows[NUMSCREENS][4];

// Names for the different types of data... used in loading patches.
char *datanames[NUMDATA] = {"Thing",   	//	#defined to be... 0
									 "Sound",   	// 1
									 "Frame",		// 2
									 "Sprite",		// 3
									 "Ammo",			// 4
									 "Weapon",		// 5
									 "Text"};   	// 6

char *objnames[NUMSCREENS] = {"Thing",		// thing
										"Frame",  	// frame
										"Weapon",	// weapon
										"Sound",  	// sound
										"Sprite",	// sprite
										"Text",		// text
										"Thing"};  	// thinglist

// Name for all the fields of all the data types... whew...
char *thingfields[23] = {"ID #",
								 "Initial frame",
								 "Hit points",
								 "First moving frame",
								 "Alert sound",
								 "Reaction time",
								 "Attack sound",
								 "Injury frame",
								 "Pain chance",
								 "Pain sound",
								 "Close attack frame",
								 "Far attack frame",
								 "Death frame",
								 "Exploding frame",
								 "Death sound",
								 "Speed",
								 "Width",
								 "Height",
								 "Mass",
								 "Missile damage",
								 "Action sound",
								 "Bits",
								 "Respawn frame"};
char *soundfields[9] = {"Offset",
								"Zero/One",
								"Value",
								"Zero 1",
								"Neg. One 1",
								"Neg. One 2",
								"Zero 2",
								"Zero 3",
								"Zero 4"};
char *framefields[7] = {"Sprite number",
								"Sprite subnumber",
								"Duration",
								"Action pointer",
								"Next frame",
								"Unknown 1",
								"Unknown 2"};
char *weaponfields[6] = {"Ammo type",
								 "Deselect frame",
								 "Select frame",
								 "Bobbing frame",
								 "Shooting frame",
								 "Firing frame"};
char *fullwepfields[8] = {"Ammo number",
								  "Init. max ammo",
								  "Ammo per item",
								  "Deselect frame",
								  "Select frame",
								  "Bobbing frame",
								  "Shooting frame",
								  "Firing frame"};

// Here are names for all of the types of Ammo, types of Weapons, and
// types of Things.
char *ammolist[6] = {"Bullets",
							"Shells",
							"Cells",
							"Rockets",
							"Not Used",
							"Unlimited"};

char *weaponlist[9]={"Fists",
							"Pistol",
							"Shotgun",
							"Chaingun",
							"Rocket Launcher",
							"Plasma Gun",
							"BFG 9000",
							"Chainsaw",
							"Super Shotgun"};

char *namelist[138] = {"Player",
							  "Trooper",
							  "Sargeant",
							  "Archvile",
							  "Archvile Attack",
							  "Revenant",
							  "Revenant Fireball",
							  "Fireball Trail",
							  "Mancubus",
							  "Mancubus Fireball",
							  "Chaingun Sargeant",

							  "Imp",
							  "Demon",
							  "Spectre",
							  "Cacodemon",
							  "Baron of Hell",
							  "Baron Fireball",
							  "Hell Knight",
							  "Lost Soul",
							  "Spiderdemon",
							  "Arachnotron",

							  "Cyberdemon",
							  "Pain Elemental",
							  "SS Nazi",
							  "Commander Keen",
							  "Big Brain",
							  "Demon Spawner",
							  "Demon Spawn Spot",
							  "Demon Spawn Cube",
							  "Demon Spawn Fire",
							  "Barrel",

							  "Imp Fireball",
							  "Caco Fireball",
							  "Rocket (in air)",
							  "Plasma Bullet",
							  "BFG Shot",
							  "Arach. Fireball",
							  "Bullet Puff",
							  "Blood Splat",
							  "Teleport Flash",
							  "Item Respawn Fog",

							  "Teleport Exit",
							  "BFG Hit",
							  "Green Armor",
							  "Blue Armor",
							  "Health Potion",
							  "Armor Helmet",
							  "Blue Keycard",
							  "Red Keycard",
							  "Yellow Keycard",
							  "Yellow Skull Key",

							  "Red Skull Key",
							  "Blue Skull Key",
							  "Stim Pack",
							  "Medical Kit",
							  "Soul Sphere",
							  "Invulnerability",
							  "Berserk Sphere",
							  "Blur Sphere",
							  "Radiation Suit",
							  "Computer Map",

							  "Lite Amp. Visor",
							  "Mega Sphere",
							  "Ammo Clip",
							  "Box of Ammo",
							  "Rocket",
							  "Box of Rockets",
							  "Energy Cell",
							  "Energy Pack",
							  "Shells",
							  "Box of Shells",

							  "Backpack",
							  "BFG 9000",
							  "Chaingun",
							  "Chainsaw",
							  "Rocket Launcher",
							  "Plasma Gun",
							  "Shotgun",
							  "Super Shotgun",
							  "Tall Lamp",
							  "Tall Lamp 2",

							  "Short Lamp",
							  "Tall Gr. Pillar",
							  "Short Gr. Pillar",
							  "Tall Red Pillar",
							  "Short Red Pillar",
							  "Pillar w/Skull",
							  "Pillar w/Heart",
							  "Eye in Symbol",
							  "Flaming Skulls",
							  "Grey Tree",

							  "Tall Blue Torch",
							  "Tall Green Torch",
							  "Tall Red Torch",
							  "Small Blue Torch",
							  "Small Gr. Torch",
							  "Small Red Torch",
							  "Brown Stub",
							  "Technical Column",
							  "Candle",
							  "Candelabra",

							  "Swaying Body",
							  "Hanging Arms Out",
							  "One-legged Body",
							  "Hanging Torso",
							  "Hanging Leg",
							  "Hanging Arms Out2",
							  "Hanging Torso 2",
							  "One-legged Body 2",
							  "Hanging Leg 2",
							  "Swaying Body 2",

							  "Dead Cacodemon",
							  "Dead Marine",
							  "Dead Trooper",
							  "Dead Demon",
							  "Dead Lost Soul",
							  "Dead Imp",
							  "Dead Sargeant",
							  "Guts and Bones",
							  "Guts and Bones 2",
							  "Skewered Heads",

							  "Pool of Blood",
							  "Pole with Skull",
							  "Pile of Skulls",
							  "Impaled Body",
							  "Twitching Body",
							  "Large Tree",
							  "Flaming Barrel",
							  "Hanging Body 1",
							  "Hanging Body 2",
							  "Hanging Body 3",

							  "Hanging Body 4",
							  "Hanging Body 5",
							  "Hanging Body 6",
							  "Pool Of Blood 1",
							  "Pool Of Blood 2",
							  "Brains",
							  "Clipboard"};

