#ifdef HAVE_MOUSE
// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

#include <dos.h>
#include <time.h>

#include "dehacked.h"
#include "mouse.h"

void callMouse(void)
// Executes the interrupt for the mouse.
// ***********
{
	intr(0x33, &reg);
}

void CloseMouse (void)
{
	reg.r_ax = 0x14;
	reg.r_cx = MOUSE_MASK;
	reg.r_es = _CS;
	reg.r_dx = FP_OFF(defaultHandler);
	callMouse ();
}

int doMouse (void)
{
	/* trick stupid mouse driver to know we are in graphic mode */
	reg.r_ax = 0;          /* detect genius mouse */
	reg.r_bx = 0;          /* be sure what mode we get */
	callMouse();
	mouse_present = (reg.r_ax ? TRUE : FALSE)   ; /* not an iret.. */
	if (mouse_present == FALSE)
		return -1;

	mouseCursorLevel = eventX = eventY = eventButtons = LastEventButtons = 0;
	eventHappened = FALSE;
	return 0;
}

int InitMouse(void)
{
	eventX = eventY = 0;
	eventHappened = FALSE;

	if (doMouse() == -1)
		return -1;
	swapEventHandler(MOUSE_MASK, defaultHandler);
	return 0;
}

void showMouseCursor (void)
{
	 reg.r_ax = 1; /* enable cursor display */
	 callMouse();
	 mouseCursorLevel++;
}

void hideMouseCursor (void)
{
	 reg.r_ax = 2; /* disable cursor display */
	 callMouse();
	 mouseCursorLevel--;
}

EBool getLastEvent(unsigned *x, unsigned *y,
						 EButton *left_button, EButton *right_button)
{
	EBool event = eventHappened ;

	eventHappened = FALSE; /* clear to next read/event */
	*x = eventX >> 3;
	*y = eventY >> 3;

	if (eventButtons & LEFTBUTTON)
		*left_button = buttonDown;
	else
		*left_button = buttonUp;

	if (eventButtons & RIGHTBUTTON)
		*right_button = buttonDown;
	else
		*right_button = buttonUp;

	return event;
}

void huge defaultHandler (void)
{
/*	asm {
		mov eventX, cx;   // where in the x region did it occur
		mov eventY, dx;
		push ax;
		mov ax, eventButtons;
		mov LastEventButtons, ax;
		pop ax;
		mov eventButtons, bx;
		mov eventHappened, 1;  // eventhappened = TRUE
	}*/

	eventX = _CX;
	eventY = _DX;
	LastEventButtons = eventButtons;
	eventButtons = _BX;
	eventHappened = TRUE;

	if ((eventButtons & LEFTBUTTON) && !(LastEventButtons & LEFTBUTTON))
	{
		lclicktime = clock();
		LastEventButtons |= LEFTBUTTON;	// Kludge, otherwise it sucks
	}

}

void swapEventHandler (unsigned mask ,void huge (*handler)())
{
	reg.r_ax = 0x14;
	reg.r_cx = mask;
	reg.r_es = _CS;
	reg.r_dx = FP_OFF(handler);
	callMouse ();
}

#endif /* HAVE_MOUSE */
