
#ifndef TTY_Keyboard_h
#define TTY_Keyboard_h

// This module provides uniform access to the keyboard through a
// variety of interfaces

// Extended key codes
#define F1    59
#define F2    60
#define F3    61
#define F4    62
#define F5    63
#define F6    64
#define F7    65
#define F8    66

#define HOME  71
#define UP    72
#define PGUP  73
#define LEFT  75
#define RIGHT 77
#define END   79
#define DOWN  80
#define PGDN  81

#define BKSP   8
#define TAB    9
#define RET   13
#define ESC   27

// Definitions for raw()
#define COOKED	0
#define RAW	1

class TTY_Keyboard {

public:
	TTY_Keyboard(void);
	virtual ~TTY_Keyboard();
	virtual const int &getstate(void);
	virtual int raw(int newstate);
	virtual int pending_input(float do_wait);
	virtual int getch(void);

	virtual void set_refresh_f(void (*func)());
	virtual void toggle_refresh(int flag);

protected:
	int keyboard_state;

	int do_refresh;
	void (*App_Refresh)();
};

// Include other keyboard modules here...
#include "x11_keyboard.h"

#endif
