/*
** Astrolog (Version 4.10) File: astrolog.h
**
** IMPORTANT NOTICE: the graphics database and chart display routines
** used in this program are Copyright (C) 1991-1994 by Walter D. Pullen
** (cruiser1@stein.u.washington.edu). Permission is granted to freely
** use and distribute these routines provided one doesn't sell,
** restrict, or profit from them in any way. Modification is allowed
** provided these notices remain with any altered or edited versions of
** the program.
**
** The main planetary calculation routines used in this program have
** been Copyrighted and the core of this program is basically a
** conversion to C of the routines created by James Neely as listed in
** Michael Erlewine's 'Manual of Computer Programming for Astrologers',
** available from Matrix Software. The copyright gives us permission to
** use the routines for personal use but not to sell them or profit from
** them in any way.
**
** The PostScript code within the core graphics routines are programmed
** and Copyright (C) 1992-1993 by Brian D. Willoughby
** (brianw@sounds.wa.com). Conditions are identical to those above.
**
** The extended accurate ephemeris databases and formulas are from the
** calculation routines in the program "Placalc" and are programmed and
** Copyright (C) 1989,1991,1993 by Astrodienst AG and Alois Treindl
** (alois@azur.ch). The use of that source code is subject to
** regulations made by Astrodienst Zurich, and the code is not in the
** public domain. This copyright notice must not be changed or removed
** by any user of this program.
**
** Initial programming 8/28,30, 9/10,13,16,20,23, 10/3,6,7, 11/7,10,21/1991.
** X Window graphics initially programmed 10/23-29/1991.
** PostScript graphics initially programmed 11/29-30/1992.
** Last code change made 3/19/1994.
*/

/*
** TO COMPILE: For most systems, especially Unix and DOS based ones, the only
** changes that should need to be made to the code are to edit or comment the
** #define's below to equal the particulars of your own system and locale:
** 
** SYSTEM SECTION: These settings describe platform and hardware specifics.
** They are all required to be set properly or the program likely won't
** compile or run. Some of these are technically optional and can be
** commented out even if your system would normally support them, e.g.
** the X11 features can be disabled even if you are running X windows.
*/

/*#define PC /* Comment out this #define if you have a Unix or some other */
           /* system that isn't the generic PC running DOS.             */

/*#define ATOF /* Comment out this #define if you have a system in which  */
             /* 'atof' and related functions aren't defined in stdio.h, */
             /* such as most PC's, VMS compilers, and NeXT's.           */

#define X11 /* Comment out this #define if you don't have X windows, or */
            /* else have them and don't wish to compile in X graphics.  */

/*#define MSG /* Comment out this #define if you don't have access to the     */
            /* Microsoft C PC graphics library as in graph.h, or you do and */
            /* have a PC and just don't wish to compile these graphics in.  */

#define SWITCHES /* Comment out this #define if your system can not handle */
                 /* parameters on the command line (such as Mac's).        */

#define MOUSE /* Comment out this #define if you don't have a mouse, or */
              /* don't wish to compile in mouse tracking features. This */
              /* is only an option if either X11 or MSG above are set.  */

#define TIME /* Comment out this #define if your compiler can't take the  */
             /* calls to the 'time' or 'localtime' functions as in time.h */

#define ENVIRON /* Comment out this #define if your system doesn't have  */
                /* environment variables or can't compile calls to them. */

/*
** FEATURES SECTION: These settings describe features that are always
** available to be compiled into the program no matter what platform or
** hardware is available. Their settings are always optional.
*/

#define GRAPH /* Comment out this #define if you don't want any graphics   */
              /* in the program. This switch allows at least generation of */
              /* bitmap files and must be set if any of the more advanced  */
              /* graphics feature additions are also compiled in.          */

#define PLACALC /* Comment out this #define if you don't want the more */
                /* accurate calculation features and formulas to be    */
                /* compiled into the program (as accessed with -b).    */

#define PS /* Comment out this #define if you don't want the ability to */
           /* generate charts in the PostScript graphics format.        */

#define META /* Comment out this #define if you don't want the ability to  */
             /* generate charts in the MS Windows metafile picture format. */

#define INTERPRET /* Comment out this #define if you don't want the ability */
                  /* to display interpretations of the various chart types. */

/* #define BIORHYTHM Comment out this #define if you don't want the    */
                  /* non-astrological biorhythm charts in the program. */

/*
** DATA CONFIGURATION SECTION: These settings describe particulars of
** your own location and where the program looks for certain info. It is
** recommended that these values be changed appropriately, although the
** program will still run if they are left alone.
*/

#ifndef PC
#define DEFAULT_DIR "/usr/local/astrolog"
#else
#define DEFAULT_DIR "C:\\ASTROLOG"
#endif
  /* Change this string to directory path program should look in for the  */
  /* astrolog.dat default file if one is not in the current directory or  */
  /* in the dirs indicated by environment variables. For PC systems, use  */
  /* two backslashes instead of one forward one to divide subdirectories. */

#define CHART_DIR DEFAULT_DIR
  /* This string is the directory the program looks in for chart info    */
  /* files (-i switch) if not in the current directory. This is normally */
  /* the default dir above but may be changed to be somewhere else.      */

#define EPHE_DIR DEFAULT_DIR
  /* This string is the directory the program looks in for the ephemeris */
  /* files as accessed with the -b switch. This is normally the default  */
  /* dir above but may be changed to be somewhere else.                  */

#define DEFAULT_LONG -7.22 /* Change these values to the longitude west    */
#define DEFAULT_LAT   45.06 /* and latitude north of your current location. */
                            /* Use negative values for east/southern areas. */

#define DEFAULT_ZONE -1.00 /* Change this number to the time zone of your */
                          /* current location in hours before (west of)  */
                          /* GMT. Use negative values for eastern zones. */

/*
** OPTIONAL CONFIGURATION SECTION: Although not necessary, one may like
** to change some of the values below: These constants affect some of
** the default parameters and other such things.
*/

#define DEFAULT_SYSTEM 0 /* Normally, Placidus houses are used (unless the */
                         /* user specifies otherwise). If you want a       */
                         /* different default system, change this number   */
                         /* to a value from 0..9 (values same as in -c).   */

#define DEFAULT_ASPECTS 5 /* Default number of aspects to use in charts. */

#define DIVISIONS 12 /* Greater numbers means more accuracy but slower  */
                     /* calculation, of exact aspect and transit times. */

#define DEFAULT_INFOFILE "astrolog.dat"
  /* Name of file to look in for default program parameters (which will */
  /* override the compile time values here, if the file exists).        */

#define ENVIRONALL "ASTROLOG"
#define ENVIRONVER "ASTR"
  /* Name of environment variables to look in for chart, ephemeris, and  */
  /* default files. The second name is a version specific variable which */
  /* gets the current version appended to it before it is accessed.      */

#define WHEELCOLS 15   /* Affects width of each house in wheel display.    */
#define WHEELROWS 11   /* Max no. of objects that can be in a wheel house. */
#define SCREENWIDTH 80 /* Number of columns to print interpretations in.   */
#define MONTHSPACE 3   /* Number of spaces between each calendar column.   */
#define MAXINDAY 100   /* Max number of aspects or transits displayable.   */
#define MAXCROSS 500   /* Max number of latitude crossings displayable.    */

#ifdef GRAPH           /* For graphics, this char affects how bitmaps are */
#ifndef PC             /* written. 'N' is written like with the 'bitmap'  */
#define BITMAPMODE 'C' /* program, 'C' is compacted somewhat (files have  */
#else                  /* less spaces), and 'V' is compacted even more.   */
#define BITMAPMODE 'B' /* 'A' means write as rectangular Ascii text file. */
#endif                 /* 'B' means write as Windows bitmap (.bmp) file.  */

#ifdef MSG
#define DEFHIRESMODE _MAXRESMODE /* 'High-resolution' PC graphics mode. */
#define DEFLORESMODE _ERESCOLOR  /* 'Flicker-free' PC graphics mode.    */
#endif
#endif /* GRAPH */

/*#define TRUENODE /* Comment out this #define if you'd prefer the 'Node' */
                 /* object to refer to the Mean North Node of the Moon  */
                 /* as opposed to the True North Node of the Moon.      */

/*
** By the time you reach here and the above values are customized as
** desired, Astrolog is ready to be compiled! Be sure to similarly
** change the values in the astrolog.dat file, which will override any
** corresponding compile time values here. Don't change any of the
** values in the section below unless you really know what you're doing.
*/

#ifdef GRAPH
#define BITMAPX  2730   /* Maximum window size allowed */
#define BITMAPY  2730
#define BITMAPX1 180    /* Minimum window size allowed */
#define BITMAPY1 180
#define DEFAULTX 480    /* Default window size */
#define DEFAULTY 480
#define SIDESIZE 160    /* Size of wheel chart information sidebar.    */
#define MAXMETA 100000L /* Max bytes allowed in a metafile.            */
#define METAMUL   12    /* Metafile coordinate to chart pixel ratio.   */
#define PSMUL     11    /* PostScript coordinate to chart pixel ratio. */
#define CELLSIZE  14    /* Size for each cell in the aspect grid.      */
#define BIODAYS   14    /* Days to include in graphic biorhythms.      */
#define DEGINC     2    /* Number of degrees per line for circles.     */
#define DEFORB   7.0    /* Min distance glyphs can be from each other  */
#endif /* GRAPH */

#define BOXH  (ansi ? 196 : '-')    /* Ansi and Ascii characters used to */
#define BOXV  (ansi ? 179 : '|')    /* print text charts.                */
#define BOXC  (ansi ? 197 : '|')
#define BOXNW (ansi ? 218 : '+')
#define BOXNE (ansi ? 191 : '+')
#define BOXSW (ansi ? 192 : '+')
#define BOXSE (ansi ? 217 : '+')
#define BOXJN (ansi ? 193 : '-')
#define BOXJS (ansi ? 194 : '-')
#define BOXJW (ansi ? 180 : '|')
#define BOXJE (ansi ? 195 : '|')
#define DEGR0 (ansi ? 248 : ' ')
#define DEGR1 (ansi ? 248 : ':')


/*
** One shouldn't ever need to change anything below this line to compile.
*/

#define ASTROLOG
#define MATRIX
#include <stdio.h>
#ifndef ATOF
#include <stdlib.h>
#endif
#include <math.h>
#ifdef PC
#include <malloc.h>
#endif
#ifdef TIME
#include <time.h>
#endif
#ifdef X11
#define ISG
#include <X11/Xlib.h>
#include <X11/Xutil.h>
#endif
#ifdef MSG
#define ISG
#include <graph.h>
#include <conio.h>
#ifdef MOUSE
#include <mouse.h>
#endif
#endif /* MSG */


/*
** Make sure only legal combinations of the graphics options are active.
*/

#ifdef X11
#ifndef GRAPH
"If 'X11' is defined 'GRAPH' must be too"
#endif
#ifdef MSG
"If 'X11' is defined 'MSG' must not be as well"
#endif
#ifdef PC
"If 'X11' is defined 'PC' must not be as well"
#endif
#endif /* X11 */

#ifdef MSG
#ifndef GRAPH
"If 'MSG' is defined 'GRAPH' must be too"
#endif
#ifdef X11
"If 'MSG' is defined 'X11' must not be as well"
#endif
#ifndef PC
"If 'MSG' is defined 'PC' must be too"
#endif
#endif /* MSG */

#ifdef MOUSE
#ifdef GRAPH
#ifndef ISG
"If 'MOUSE' is defined 'X11' or 'MSG' must be too"
#endif
#endif /* GRAPH */
#endif /* MOUSE */

#ifdef PS
#ifndef GRAPH
"If 'PS' is defined 'GRAPH' must be too"
#endif
#endif /* PS */

#ifdef META
#ifndef GRAPH
"If 'META' is defined 'GRAPH' must be too"
#endif
#endif /* META */


/*
******************************************************************************
** Program Constants.
******************************************************************************
*/

#ifndef FALSE
#define FALSE 0
#endif
#ifndef TRUE
#define TRUE  1
#endif
#define APPNAME "Astrolog"
#define VERSION "4.10"
#define DATE    "March 1994"
#define OFF     0
#define ON      1
#define STRING  80
#define DEGD    360
#undef  PI
#define PI      3.14159265358979323846
#define DEGREES 360.0
#define DEGHALF 180.0
#define DEGQUAD 90.0
#define DEGRAD  (DEGHALF/PI)
#define G2JYEA  1582
#define G2JMON  _OCT
#define G2JDAY1 4
#define G2JDAY2 15
#define SD2000  -24.736467
#define TROPIC  23.44578889
#define SMALL   (1.7453E-09)
#define LARGE   1000.0
#define ROUND   0.5
#define ESCAPE  '\33'
#define BELL    '\7'
#define SCALE   (scale/100)

/* Array index limits */

#define SIGNS   12
#define SYSTEMS 11
#define ASPECTS 18
#define ASPECTI 11
#define OBJECTI U_HI
#define TOTAL   79
#define FONTX   6
#define FONTY   10
#define FONTXT  (FONTX*scalet)
#define FONTYT  (FONTY*scalet)
#define SIDET   (SIDESIZE*scalet)

/* Object array index values */

#define PLANETS 14
#define THINGS  16
#define OBJECTS 20
#define URANIANS 8
#define STARS   47
#define BASE    32
#define C_LO    21
#define C_HI    24
#define U_LO    25
#define U_HI    32
#define S_LO    33
#define S_HI    79

/* Other specific index values */

#define _JAN 1
#define _FEB 2
#define _MCH 3
#define _APR 4
#define _MAY 5
#define _JUN 6
#define _JUL 7
#define _AUG 8
#define _SEP 9
#define _OCT 10
#define _NOV 11
#define _DEC 12
#define _FIR 0
#define _EAR 1
#define _AIR 2
#define _WAT 3
#define _ARI 1
#define _TAU 2
#define _GEM 3
#define _CAN 4
#define _LEO 5
#define _VIR 6
#define _LIB 7
#define _SCO 8
#define _SAG 9
#define _CAP 10
#define _AQU 11
#define _PIS 12
#define _SUN 1
#define _MOO 2
#define _MER 3
#define _VEN 4
#define _MRS 5
#define _JUP 6
#define _SAT 7
#define _URA 8
#define _NEP 9
#define _PLU 10
#define _CHI 11
#define _NOD 16
#define _FOR 17
#define _MC  18
#define _ASC 19
#define _VTX 20
#define _DIR -2
#define _SIG -1
#define _CON 1
#define _OPP 2
#define _SQU 3
#define _TRI 4
#define _SEX 5
#define _INC 6
#define _SSX 7
#define _SSQ 8
#define _SES 9
#define _QUI 10
#define _BQN 11
#define _PHY 23.0
#define _EMO 28.0
#define _INT 33.0

/* Bit mask values for chart specification */

#define DASHv 0x1
#define DASHw 0x2
#define DASHg 0x4
#define DASHm 0x8
#define DASHZ 0x10
#define DASHS 0x20
#define DASHj 0x40
#define DASHL 0x80
#define DASHK 0x100
#define DASHd 0x200
#define DASHD 0x400
#define DASHE 0x800
#define DASHt 0x1000
#define DASHT 0x2000
#define DASHe 0xFFF

/* Bit mask values for subchart specification */

#define DASHv0 0x1
#define DASHw0 0x2
#define DASHg0 0x4
#define DASHga 0x8
#define DASHm0 0x10
#define DASHZ0 0x20
#define DASHZd 0x40
#define DASHj0 0x80
#define DASHL0 0x100
#define DASHKy 0x200
#define DASHdm 0x400
#define DASHEy 0x800
#define DASHXW0 0x1000
#define DASHXP0 0x2000

/* Bit mask values for table specification */

#define DASHO0 0x1
#define DASHHc 0x2
#define DASHH  0x4
#define DASHH0 0x8
#define DASHO  0x10
#define DASHA  0x20
#define DASHI0 0x40

/* Bit mask values for option specification */

#define DASHQ 0x1
#define DASHs 0x2
#define DASHC 0x4
#define DASHu 0x8
#define DASHf 0x10
#define DASH3 0x20
#define DASHG 0x40
#define DASHo 0x80
#define DASHX 0x100
#define DASHQ0 0x200
#define DASHs0 0x400
#define DASHp0 0x800
#define DASHo0 0x1000

/* Relationship chart modes */

#define DASHr  1
#define DASHrc 2
#define DASHrm 3
#define DASHrd 4
#define DASHrb 5
#define DASHr0 -1
#define DASHrp -2

/* Graphics chart modes */

#define MODEv 'v'
#define MODEw 'w'
#define MODEg 'g'
#define MODEZ 'Z'
#define MODES 'S'
#define MODEL 'L'
#define MODEE 'E'
#define MODEW 'W'
#define MODEG 'G'
#define MODEP 'P'
#define MODEb 'b'

/* Ansi colors */

#define REVERSE -2
#define DEFAULT -1
#define BLACK   0
#define MAROON  1
#define DKGREEN 2
#define ORANGE  3
#define DKBLUE  4
#define PURPLE  5
#define DKCYAN  6
#define LTGRAY  7
#define DKGRAY  8
#define RED     9
#define GREEN   10
#define YELLOW  11
#define BLUE    12
#define MAGENTA 13
#define CYAN    14
#define WHITE   15

/* Termination codes */

#define _ERROR -1
#define _OK    0
#define _FATAL 1
#define _FORCE 2

#ifndef _ZRES256COLOR
#define _ZRES256COLOR 263
#endif


/*
******************************************************************************
** Macro Functions.
******************************************************************************
*/

#define LOBYTE(W) ((byte) (W))
#define HIBYTE(W) ((byte) ((word)(W) >> 8 & 0xFF))
#define LOWORD(L) ((word) (dword)(L))
#define HIWORD(L) ((word) ((dword)(L) >> 16 & 0xFFFF))
#define MAKEWORD(L, H) ((word)LOBYTE(L) | (word)((byte)(H)) << 8)
#define MAKELONG(L, H) ((dword)LOWORD(L) | (dword)((word)(H)) << 16)
#define MAKEQUAD(A, B, C, D) MAKELONG(MAKEWORD(A, B), MAKEWORD(C, D))
#define RGB(R, G, B) ((dword)((byte)(R) | (word)(G)<<8 | (dword)(byte)(B)<<16))
#define RGBR(R) LOBYTE(R)
#define RGBG(G) HIBYTE(G)
#define RGBB(B) ((byte) ((dword)(B) >> 16 & 0xFF))
#define INTTOHEX(I) (char) ((I) < 10 ? '0' + (I) : 'a' + (I) - 10)
#define ISEGA(R) ((R) == _ERESNOCOLOR || (R) == _ERESCOLOR)
#define ISCGA(R) ((R) == _HRESBW || (R) == _HRES16COLOR)
#define EGATOVGA(X) MULTDIV((X), 480, 350)
#define CGATOVGA(X) MULTDIV((X), 480, 200)

#define MAX(A, B) ((A) > (B) ? (A) : (B))
#define MIN(A, B) ((A) < (B) ? (A) : (B))
#define SGN(A) ((A) < 0 ? -1 : (A) > 0 ? 1 : 0)
#define SGN2(A) ((A) < 0.0 ? -1.0 : 1.0)
#define FRACT(A) ((A) - floor(A))
#define CAP(C) ((C) >= 'a' && (C) <= 'z' ? (C) - 'a' + 'A' : (C))
#define UNCAP(C) ((C) >= 'A' && (C) <= 'Z' ? (C) - 'A' + 'a' : (C))
#define MULTDIV(X, Y, Z) ((int)((long)(X) * (Y) / (Z)))
#define RATIO(X, Y, Z) ((X) + ((Y) - (X)) * (Z))
#define STOZ(S) ((real)(((S)-1)*30))
#define ZTOS(D) (((int)(D))/30+1)
#define DTOR(D) ((D)/DEGRAD)
#define RTOD(R) ((R)*DEGRAD)
#define ASIN(R) ((R)*(R) == 1.0 ? (R)*PI/2.0 : atan((R)/sqrt(1.0-(R)*(R))))
#define ACOS(R) ((R) == 0.0 ? 0.0 : atan(sqrt(1.0-(R)*(R))/(R)))
#define ATAN(R) atan(R)
#define SIND(D) sin((D)/DEGRAD)
#define COSD(D) cos((D)/DEGRAD)
#define RSIND(R, D) ((int)((real)(R)*SIND((real)D)))
#define RCOSD(R, D) ((int)((real)(R)*COSD((real)D)))
#define SWAP(A, B) (A)^=(B)^=(A)^=(B)
#define SORT(A, B) if ((A) > (B)) SWAP(A, B)

#define IsCusp(I) ((I) >= C_LO && (I) <= C_HI)
#define IsObject(I) ((I) < THINGS || (I) > C_HI)
#define IsThing(I) ((I) <= THINGS || (I) > C_HI)
#define IsItem(I) ((I) >= 1 && (I) <= TOTAL)
#define DayInYear(Y) (365-28+DayInMonth(2, Y))
#define DaysInYear(Y) (DayInYear(Y)-((Y) == G2JYEA)*(G2JDAY2-G2JDAY1-1))

#define IsValidMon(M) ((M) >= 1 && (M) <= 12)
#define IsValidDay(D, M, Y) ((D) >= 1 && (D) <= DayInMonth(M, Y))
#define IsValidYea(Y) ((Y) >= -20000 && (Y) <= 20000)
#define IsValidTim(T) ((T) > -2.0 && (T) < 24.0)
#define IsValidZon(Z) ((Z) >= -24.0 && (Z) <= 24.0)
#define IsValidLon(O) ((O) >= -DEGHALF && (O) <= DEGHALF)
#define IsValidLat(A) ((A) >= -DEGQUAD && (A) <= DEGQUAD)
#define IsValidAspect(A) ((A) >= 0 && (A) <= ASPECTS)
#define IsValidSystem(H) ((H) >= 0 && (H) <= SYSTEMS)
#define IsValidDivision(D) ((D) > 0 && (D) <= 2880)
#define IsValidWheel(R) ((R) >= 1 && (R) <= WHEELROWS)
#define IsValidScreen(W) ((W) >= 20 && (W) <= 200)
#define IsValidTextrows(R) ((R) == 25 || (R) == 43 || (R) == 50)
#define IsValidGrid(C) ((C) > 0 && (C) <= TOTAL)
#define IsValidScale(S) ((S) >= 100 && (S) <= 400 && (S)%100 == 0)
#define IsValidGraphx(X) ((X) >= BITMAPX1 && (X) <= BITMAPX)
#define IsValidGraphy(Y) ((Y) >= BITMAPY1 && (Y) <= BITMAPY)
#define IsValidResmode(R) ((R) >= _MAXRESMODE && (R) <= _ZRES256COLOR)
#define IsValidBmpmode(M) \
  ((M) == 'N' || (M) == 'C' || (M) == 'V' || (M) == 'A' || (M) == 'B')

#define SetCore(M, D, Y, T, Z, O, A) \
  MM = (M); DD = (D); YY = (Y); TT = (T); ZZ = (Z); OO = (O); AA = (A)
#define SetMain(M, D, Y, T, Z, O, A) \
  Mon = (M); Day = (D); Yea = (Y); Tim = (T); Zon = (Z); Lon = (O); Lat = (A)
#define SetSave(M, D, Y, T, Z, O, A) MonX = (M); DayX = (D); YeaX = (Y); \
  TimX = (T); ZonX = (Z); LonX = (O); LatX = (A)
#define SetTwin(M, D, Y, T, Z, O, A) Mon2 = (M); Day2 = (D); Yea2 = (Y); \
  Tim2 = (T); Zon2 = (Z); Lon2 = (O); Lat2 = (A)
#define SIGNAM(A) signname[A][0], signname[A][1], signname[A][2]
#define OBJNAM(A) objectname[A][0], objectname[A][1], objectname[A][2]
#define MONNAM(A) monthname[A][0], monthname[A][1], monthname[A][2]
#define DAYNAM(A) dayname[A][0], dayname[A][1], dayname[A][2]
#define dabs(A) fabs(A)
#define signansi(A) elemansi[(A)-1 & 3]
#define signcolor(A) elemcolor[(A)-1 & 3]
#define printc(A) putc(A, S)
#define printl() printc('\n')
#define printl2() fprintf(S, "\n\n")
#define loop for (;;)

#ifndef PC
#define DIR_SEP '/'
#define DASH '-'
#define FAR
#define PTR *
#define Allocate(P, B, T) (P) = (T) malloc(B)
#define Deallocate(P) free(P)
#else
#define DIR_SEP '\\'
#define DASH '/'
#define FAR far
#define PTR huge *
#define Allocate(P, B, T) (P) = (T) halloc((long)(B), sizeof(byte))
#define Deallocate(P) hfree(P)
#endif

#ifdef GRAPH
#define epsfile (psfile > TRUE)

/* Are particular coordinates on the chart? */
#define ISLEGAL(X, Y, x1, y1, x2, y2) \
  ((X) >= x1 && (X) < x2 && (Y) >= y1 && (Y) < y2)
#define ISCHART(X, Y) ISLEGAL((X), (Y), 0, 0, chartx, charty)

/* Get a coordinate based on chart radius, a fraction, and (co)sin value. */
#define POINT(U, R, S) ((int) ((R)*(U)*(S)+Sgn((S))/3.0))

/* Determine (co)sin factors based on zodiac angle and chart orientation. */
#define PX(A) COSD(A)
#define PY(A) SIND(A)
#define PZ(A) Mod(DEGHALF-(A)+asc)

/* Do settings indicate the current chart should have the info sidebar? */
#define ISSIDEBAR \
  ((modex == MODEv || modex == MODEw) && xtext && !(exdisplay & DASHv0))

/* Is the current chart most properly displayed as a square graphic? */
#define ISSQUARE \
  (modex == MODEv || modex == MODEw || modex == MODEg || \
  (modex == MODEZ && (exdisplay & DASHZ0) > 0) || \
  modex == MODES || modex == MODEG || modex == MODEP)
#endif


/*
******************************************************************************
** Type Definitions.
******************************************************************************
*/

#define byte  unsigned char
#define word  unsigned short
#define dword unsigned long
#define bool  int
#define _int  unsigned int
#define real  double

typedef struct _gridstruct {
  byte  n[TOTAL+1][TOTAL+1];
  short v[TOTAL+1][TOTAL+1];
} gridstruct;

typedef struct _crosstruct {
  real lat[MAXCROSS];
  real lon[MAXCROSS];
  int obj1[MAXCROSS];
  int obj2[MAXCROSS];
} crosstruct;

#ifdef GRAPH
#define colrgb unsigned long
#define colpal int

typedef struct _circlestruct {
  real x[DEGD+1];
  real y[DEGD+1];
} circlestruct;

typedef byte PTR bitmap;
#endif /* GRAPH */


/*
******************************************************************************
** Function Declarations.
******************************************************************************
*/

/* From data.c */

extern FILE *S;
extern int noswitches, total, aspects, universe, centerplanet, placalc,
  seconds, housesystem, ansi, divisions, screenwidth, eurodate, eurotime,
  smartcusp, column80, todisplay, exdisplay, andisplay, operation, relation,
  ratio1, ratio2, interpret, progress, multiplyfactor, onasc,
  wheelrows, graphstep, autom;
extern char *progname, *filename, *filename2, string[];
extern real addfactor, progday, defzone, deflong, deflat, modulus;
extern int MM, DD, YY, Mon, Day, Yea, Mon2, Day2, Yea2, MonX, DayX, YeaX,
  Delta;
extern real TT, ZZ, OO, AA, Tim, Zon, Lon, Lat, Tim2, Zon2, Lon2, Lat2,
  TimX, ZonX, LonX, LatX, SD, T, JD, Jdp, MC, Asc, Vtx;

extern real planet[], planetalt[], house[], ret[],
  spacex[], spacey[], spacez[], force[],
  planet1[], planet2[], planetalt1[], planetalt2[],
  house1[], house2[], ret1[], ret2[];
extern gridstruct PTR grid;
extern byte inhouse[], inhouse1[], inhouse2[];
extern int starname[], objectansi[];

extern byte ignore[], ignore2[];
extern real aspectangle[], aspectorb[], planetorb[], planetadd[];
extern int ruler1[], ruler2[], exalt[], rules[],
  mainansi[], rainbowansi[], elemansi[], aspectansi[];
extern real objectinf[], houseinf[], aspectinf[], transitinf[];

extern char *appname, *signname[], *signabbrev[], *signenglish[],
  *housetradition[], *objectname[], *systemname[], *aspectname[],
  *aspectabbrev[], *aspectglyph[], *element[], *mode[],
  *monthname[], *dayname[], *dirname[], *post[];
extern byte errorcount[];
extern real planetdata[], starbright[], stardata[];
extern char *mindpart[], *description[], *desire[], *lifearea[],
  *interact[], *therefore[], *modifier[3][11];

/* From general.c */

#define PrintAltitude(D) fprintf(S, "%s", CharAltitude(D))
#define BadVal2(O, V) BadVal(O, (int)V)

extern void SwapReal(),
  Terminate(), PrintWarning(), PrintError(), TooFew(), BadVal(),
  PrintTab(), InputString(), AnsiColor(), PrintZodiac(), GetTimeNow();
extern int StringLen(), StringCmp(), Mod12(), DayInMonth(), DaysInMonth(),
  DayOfWeek(), AddDay();
extern long Dvd();
extern real Sgn(), Angle(), Mod(), DecToDeg(), DegToDec(),
  MinDistance(), MinDifference(), Midpoint(), Orb();
extern char Dignify(), *CharZodiac(), *CharAltitude(), *CharDate(),
  *CharTime(), *CharZone(), *CharLocation(), *ProcessProgname();
extern bool InputData();
extern FILE *OpenFile();

/* From formulas.c */

#define EclToEqu(Z, L) CoorXform(Z, L, DTOR(TROPIC))
#define EquToEcl(Z, L) CoorXform(Z, L, DTOR(-TROPIC))
#define EquToLocal(Z, L, T) CoorXform(Z, L, T)
#define ReadPlanetData() (*datapointer++)
#define Biorhythm(D, R) (sin(((D)/(R))*PI*2.0)*100.0)
#define JulianDayFromTime(T) ((T)*36525.0+2415020.0)

extern long MdyToJulian();
extern void JulianToMdy();
extern real ProcessInput();
extern void CoorXform();
extern int HousePlaceIn();
extern void HousePlace();
extern void ComputeStars();
extern real CastChart();

/* From charts.c */

extern void CreateElemTable();
extern void ChartLocation();
extern void ChartGrid();
extern void PrintGrand();
extern void DisplayGrands();
extern void PrintHouse();
extern void PrintWheelSlot();
extern void ChartWheel();
extern void ChartAspect();
extern void ChartMidpoint();
extern void ChartHorizon();
extern void ChartSpace();
extern void ChartAstroGraph();

/* From options.c */

extern void CreateGrid();
extern void CreateGridRelation();
extern void CastRelation();
extern void PrintAspect();
extern void DisplayInDaySearch();
extern void DisplayInDayInfluence();
extern void DisplayTransitSearch();
extern void DisplayTransitInfluence();
extern void DisplayEphemeris();
extern void DisplayCalendarMonth();
extern void DisplayCalendarYear();
extern void PrintChart();

/* From intrpret.c */

extern void FieldWord();
extern void InterpretGeneral();
extern void InterpretAspectGeneral();
extern void InterpretLocation();
extern void InterpretAspect();
extern void InterpretGrid();
extern void InterpretMidpoint();
extern void InterpretInDay();
extern void InterpretTransit();
extern void InterpretSynastry();
extern void InterpretAspectRelation();
extern void InterpretGridRelation();
extern void InterpretMidpointRelation();
extern void SortRank();
extern void ChartInfluence();

/* From driver.c */

extern void Prints();

#ifdef GRAPH
/* From xdata.c */

#ifdef X11
extern Colormap cmap;
extern Display *disp;
extern GC gc, pmgc;
extern KeySym key;
extern Pixmap pixmap, icon;
extern Window window, root;
extern XEvent event;
extern XSizeHints hint;
extern int screen, depth;
extern char xkey[];
extern char icon_bits[];
extern char *rgbname[];
extern colrgb rgbind[];
#endif
#ifdef MSG
extern int hiresmode, loresmode;
#endif

extern bitmap bm;
extern word PTR metacur;
extern circlestruct PTR circ;
extern char modex, bitmapmode, *outputfile, *dispname;
extern colrgb fg, bg, rgb[], rgbbmp[];
extern colpal colcur, metafillcol, on, off, hilite, gray;
extern colpal maincolor[], rainbowcolor[],
  elemcolor[], aspectcolor[], objectcolor[];
extern int xfile, xbitmap, psfile, metafile, xmono, xcolor, xreverse, 
  xroot, xtext, xbonus, xlabel, xborder, xfont;
extern int bitmaprow, xnow, xeast, scale, textrows, gridobjects, psinchz,
  metawid, offsetx, offsety, turtlex, turtley, chartx, charty, degree, scalet;
extern real psinchx, psinchy, tilt;

extern char *signdraw[], *objectdraw[], *housedraw[],
  *aspectdraw[], *asciidraw[], *worlddata[];

/* From xgeneral.c */

#define AIND(B, X, Y) ((B)[(long)(Y)*(long)(bitmaprow) + ((X) >> 1)])
#define PGET(B, X, Y) (AIND(B, X, Y) >> (((X)&1^1) << 2) & 15)
#define PSET(B, X, Y, O) AIND(B, X, Y) = AIND(B, X, Y) & \
  15 << (((X)&1) << 2) | (O) << (((X)&1^1) << 2)

#define PutByte(A) putc((byte) (A), data)
#define PutWord(A) PutByte(LOBYTE(A)); PutByte(HIBYTE(A))
#define PutLong(A) PutWord(LOWORD(A)); PutWord(HIWORD(A))

#define DrawEdge(X1, Y1, X2, Y2) DrawBox(X1, Y1, X2, Y2, 1, 1)
#define DrawEdgeAll() DrawEdge(0, 0, chartx-1, charty-1)
#define DrawLine(X1, Y1, X2, Y2) DrawDash(X1, Y1, X2, Y2, 0)
#define DrawCircle(X, Y, RX, RY) \
  DrawEllipse((X)-(RX), (Y)-(RY), (X)+(RX), (Y)+(RY))

extern void WriteFile();
extern void PSbegin();
extern void PSend();
extern void WriteMeta();
extern void DrawColor();
extern void DrawPoint();
extern void DrawSpot();
extern void DrawBlock();
extern void DrawBox();
extern void DrawClearScreen();
extern void DrawDash();
extern void DrawWrap();
extern void DrawClip();
extern void DrawEllipse();
extern void DrawText();
extern void DrawSign();
extern void DrawHouse();
extern void DrawObject();
extern void DrawAspect();
extern void DrawTurtle();

/* From xcharts.c */

extern int DrawPrint();
extern void DrawInfo();
extern void XChartWheel();
extern void XChartAstroGraph();
extern void XChartGrid();
extern void XChartHorizon();
extern void XChartHorizonSky();
extern void XChartSpace();
extern void XChartEphemeris();

/* From xoptions.c */

extern bool Proper();
extern bool InitCircle();
extern void FillSymbolRing();
extern void FillSymbolLine();
extern int ReadWorldData();
extern int GlobeCalc();
extern void DrawGlobe();
extern void DrawLeyLine();
extern void DrawLeyLines();
extern void DrawWorld();
extern real XHousePlaceIn();
extern void XChartWheelRelation();
extern void XChartGridRelation();
extern void XChartBiorhythm();
extern void XChart();

/* From xdriver.c */

extern void XColorInit();
extern void XDisplaySwitches();
extern bool XAction();
extern int XProcessSwitches();
#endif /* GRAPH */

#ifdef PLACALC
/* From placalc.c */

extern int PlacalcPlanet();
extern double julday();
extern void revjul();
#endif

/* astrolog.h */
