'\" t
.\"	aegis - project change supervisor
.\"	Copyright (C) 1990, 1991, 1992, 1993, 1994, 1995 Peter Miller;
.\"	All rights reserved.
.\"
.\"	This program is free software; you can redistribute it and/or modify
.\"	it under the terms of the GNU General Public License as published by
.\"	the Free Software Foundation; either version 2 of the License, or
.\"	(at your option) any later version.
.\"
.\"	This program is distributed in the hope that it will be useful,
.\"	but WITHOUT ANY WARRANTY; without even the implied warranty of
.\"	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
.\"	GNU General Public License for more details.
.\"
.\"	You should have received a copy of the GNU General Public License
.\"	along with this program; if not, write to the Free Software
.\"	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.\"
.\" MANIFEST: source for the README file
.\"
.TH readme aegis
.if n .hy 0
.if n .ad l
.if n .nr IN 8n
.so ../doc/version.so
.SH NAME
aegis \- project change supervisor
.br
.if t .ds C) \(co
.if n .ds C) (C)
Copyright \*(C) \*(Y) Peter Miller;
All rights reserved.
.PP
.I Aegis
is distributed under the terms of the
GNU General Public License.
See the LICENSE section, below, for more details.
.PP
.B aegis
(ee.j.iz)
.I n.,
a protection,
a defence.
.SH DESCRIPTION
.I Aegis
is a CASE tool with a difference.
In the spirit of the UNIX Operating System,
.I Aegis
is a small component designed to work with other programs.
.PP
Many CASE systems attempt to provide everything,
from bubble charts to source control to compilers.
Users are trapped with the components supplied by the CASE system,
and if you don't like one of the components (it may be too limited,
for instance), then that is just tough.
.PP
In contrast,
UNIX provides many components of a CASE system \- compilers,
editors,
dependency maintenance tools (such as make),
source control tools (such as RCS).
You may substitute the tool of your choice
if you don't like the ones supplied with the system \- gcc, jove, cake,
to name just a few.
.I Aegis
adds to this list with software configuration
management,
and true to UNIX philosophy,
.I Aegis
does not
dictate the choice of any of the other tools (although it may stretch them
to their limits).
.PP
Enough hype, what is it that
.I Aegis
does?
Just what is software configuration management?
This question is sufficiently broad as to require a book in answer.
In essence,
.I Aegis
is a project change supervisor.
It provides a
framework within which a team of developers may work on many changes to a
program independently,
and
.I Aegis
coordinates integrating these
changes back into the master source of the program,
with as little disruption as possible.
Resolution of contention for source files,
a major headache for any project with more than one developer,
is one of
.IR Aegis 's
major functions. 
.PP
It should be noted that
.I Aegis
is a developer's tool,
in the same sense as make or RCS are developer's tools.
It is not a manager's tool \- it
does not provide progress tracking or manage work allocation.
.br
.ne 1i
.SH BENEFITS
So why should you use
.IR Aegis ?
.PP
.I Aegis
uses a particular model of the development of software
projects.
This model has a master source (or baseline) of a project,
and a team of developers creating changes to be made to this baseline.
When a change is complete,
it is integrated with the baseline,
to become the new baseline.
Each change must be atomic and self-contained,
no change is allowed to cause the baseline to cease to work.
"Working" is defined as passing it's own tests.
The tests are considered part of the baseline.
.I Aegis
provides support for the developer so that an entire copy of
the baseline need not be taken to change a few files,
only those files which are to be changed need to be copied.
.PP
In order to ensure that changes are unable to
cause the baseline to cease to work,
.I Aegis
mandates that changes be accompanied by at least one test,
and that all such tests be known to complete successfully.
These steadily accumulated tests form an ever increasing
regression test suite for all later changes.
There is also a mandatory review stage for each change to the baseline.
While these requirements may be relaxed per-change or even per-project,
doing so potentially compromises the "working" definition of the baseline.
.PP
The win in using
.I Aegis
is that there are
.I O(n)
interactions between
developers and the baseline.
Contrast this with a master source which is
being edited directly by the developers - there are
.I O(n!)
interactions between
developers - this makes adding "just one more" developer a potential disaster.
.PP
Another win is that the project baseline always works.
Always having a working baseline means that a version is always available for
demonstrations,
or those "pre-release snapshots" we are always forced to provide.
.PP
The above advantages are all very well - for management types.
Why should Joe Average Programmer use
.IR Aegis ?
Recall that RCS provides file locking,
but only for one file at a time.
.I Aegis
provides the file locking,
atomically,
for the set of files in the change.
Recall also that RCS locks the file the instant you start editing it.
This makes popular files a project bottleneck.
.I Aegis
allows concurrent editing,
and a resolution mechanism just before the
change must be integrated,
meaning fewer delays for J.A.Programmer.
.br
.ne 1i
.SH NEW IN THIS RELEASE
A number of features have been added to
.I Aegis
with this release.
A few of them are detailed here:
.so new.so
.PP
Plus the usual crop of bug fixes and tinkering.
For excruciating detail,
and also acknowledgements of those who generously sent me feedback,
please see the
.I aux/CHANGES.\*(v)
file included in this distribution.
.br
.ne 1i
.SH ARCHIVE SITE
The latest version of
.I Aegis
is available by anonymous FTP from:
.RS
.TS
center,tab(;);
l l s
l l l.
Host:;ftp.nau.edu (134.114.64.90)
Dir:;/pub/Aegis
File:;aegis.\*(v).tar.Z;# the complete source
File:;aegis.\*(v).patch.Z;# patch to take \*(w) to \*(v)
File:;aegis.\*(v).ps.Z;# PostScript of the User Guide
File:;aegis.\*(v).faq;# Frequently Asked Questions
.TE
.RE
.PP
To use anonymous FTP,
give "anonymous" as the user name (omit the quotes)
and your email address as the password.
.PP
My grateful thanks to Paul Balyoz <pab@ftp.cse.nau.edu>
for his generosity in providing this archive space.
.PP
This directory also contains a few other pieces of software written by me.
Some are referred to in the
.I Aegis
documentation.
Please have a look if you are interested.
.PP
For those of you without FTP,
I recommend the use of an ftp-by-email server.
Here is a list of a few (there are many more):
.RS
.nf
ftpmail@decwrl.dec.com
ftpmail@cs.uow.edu.au
.fi
.RE
.PP
In general, you can get a help message about how to use each system
by sending email with a subject of "help"
and a message body containing just the word "help".
.br
.ne 1i
.SH MAILING LIST
A mailing list has been created so that users of
.I Aegis
may exchange ideas about how to use
.IR Aegis .
Discussion may include,
but is not limited to:
bugs, enhancements, and applications.
The list is not moderated.
.PP
The address of the mailing list is
.RS
.ft CW
aegis-users@agso.gov.au
.ft R
.RE
.PP
To subscribe to this mailing list,
send an email message to \f(CWmajordomo@agso.gov.au\fP with
a message body containing the single line
.RS
.ft CW
subscribe aegis-users
.ft R
.RE
Please note that \f(CWagso.gov.au\fP is an Internet site,
so if you have an address which is not readily derived from
your mail headers (majordomo is only a Perl program, after all)
you will need to use a message of the form:
.RS
.ft CW
subscribe aegis-users \fIaddress\fP
.ft R
.RE
where \fIaddress\fP is an email address which
makes sense from an Internet site.
.PP
The software which handles this mailing list
.if n CANNOT
.if t .B cannot
send you a copy of
.IR Aegis .
Please use FTP or ftp-by-email, instead.
.br
.ne 1i
.SH BUILDING
Instructions on how to build and test
.I Aegis
are to be found in the
.I BUILDING
file included in this distribution.
.br
.ne 1i
.SH SOME HISTORY
The idea for
.I Aegis
did not come full-blown into my head in the shower,
as some of my programs do,
but rather from working in a software shop
which used a simplistic form of something similar.
That system was held together by chewing-gum and string,
it was written in a disgusting variant of Basic,
and by golly the damn thing worked (mostly).
.I Aegis
is nothing like it,
owes none of its code to that system,
and is far more versatile.
It turns out that the system used is nothing new,
and is described in many SCM textbooks;
it is the result of systematically resolving development issues
for large-ish teams.
.PP
Since that company decided to close down our section
(the company was under attack by a hostile takeover bid)
we all moved on simultaneously (all 60 of us),
sometimes working together,
and sometimes not,
but always keeping in touch.
With suggestions and conversations with
some of them early in 1990,
the manual entries for
.I Aegis
took shape,
and formed most of the design document for
.IR Aegis .
.PP
Since getting the first glimmerings of a functional
.I Aegis
late in 1990 it
is increasingly obvious that I never want to be without it ever again.
All of my sources that I modify are instantly placed under
.IR Aegis ,
as is anything I distribute.
All code I write for myself,
and all new code I write for my employer,
goes under
.IR Aegis .
Why?
Because it has fewer bugs!
.PP
Example: one of the sources I carry with me from job to job is "cook",
my dependency maintenance tool.
Cook had existed for 3 years before
.I Aegis
appeared on the scene,
and I used it daily.
When I placed cook under
.IR Aegis ,
I found 6 bugs!
Since then I have found a few more.
Not only are there now fewer bugs,
but they never come back,
because the regression test suite always grows.
.br
.ne 1i
.SH LICENSE
.I Aegis
is free software;
you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation;
either version 2 of the License,
or (at your option) any later version.
.PP
.I Aegis
is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY;
without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
See the GNU General Public License for more details.
.PP
You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
.PP
It should be in the
.I LICENSE
file included in this distribution.
.br
.ne 1i
.SH AUTHOR
.TS
tab(;);
l r l.
Peter Miller;UUCP:;uunet!munnari!agso.gov.au!pmiller
\f(CW/\e/\e*\fR;Internet:;pmiller@agso.gov.au
.TE
