/*  $Id$


    Part of XPCE

    Designed and implemented by Anjo Anjewierden and Jan Wielemaker

    E-mail: jan@swi.psy.uva.nl


    Copyright (C) 1994 University of Amsterdam. All rights reserved.

*/


#ifdef MD

#include MD

#endif


#ifdef __WINDOWS__

#include <windows.h>

#endif


#define __XFILE_KERNEL__

#include <stdio.h>

#include <stdlib.h>

#include <stdarg.h>

#include <ctype.h>

#include <sys/stat.h>

#include <io.h>

#include <direct.h>

#include <errno.h>

#include "xfile.h"


#ifndef EOS

#define EOS '\0'

#endif


#ifndef TRUE

#define TRUE 1

#endif


#ifndef FALSE

#define FALSE 0

#endif


#ifndef MAXPATHLEN

#define MAXPATHLEN 256

#endif


#ifndef streq

#define streq(a, b) (strcmp(a, b) == 0)

#endif



		 /*******************************

		 *     FILES AND DIRECTORIES	*

		 *******************************/


static char	x_dirsep    = '/';	/* Internal dir sep */

static char	xos_dirsep  = '\\';	/* operating system dir-sep */

static int	x_maxpath   = 256;	/* max # chars for a name */

static int	x_maxfile   = 12;	/* for dos */

static int	x_maxdots   = 1;	/* max 1 dot per name */

static int	x_maxbase   = 8;	/* max chars before dot */

static int	x_maxext    = 3;	/* max chars after dot */

static int	x_caseexact = FALSE;	/* exactcase? */


#undef IS_DIR_SEPARATOR

#define IS_DIR_SEPARATOR(c) ((c) == xos_dirsep || (c) == x_dirsep)

#define IS_DRIVEROOT(s) (isalpha(s[0]) && s[1] == ':' && s[2] == EOS)

#define DRIVE_FROM_PATH(buf) (tolower(buf[0]) - 'a' + 1)


char *

_xos_canonical_filename(const char *spec, char *xname)

{ const char *s = spec;

  char *p = xname;

  register int limit = x_maxpath-1;


  if (isalpha(s[0]) && s[1] == ':')

  { *p++ = '/';

    *p++ = *s++;

    *p++ = *s++;

    limit -= 3;

  }

  for(; *s && limit; s++, p++, limit--)

    *p = (*s == '\\' ? '/' : *s);

  *p = EOS;


  if ( !x_caseexact )

    strlwr(xname);


  return xname;

}



char *

_xos_limited_os_filename(const char *spec, char *limited)

{ int len;

  int dots;

  int new;

  const char *in = spec;

  char *out = limited;


  for(new=TRUE; *in; in++)

  { if ( new ) 

    { len = x_maxbase;

      dots = 0;

      if ( in[1] == '.' )		/* ../, ./ */

      { int copy = (in[2] == '.' ? 2 : 1);

	

	if ( IS_DIR_SEPARATOR(in[copy+1]) || in[copy+1] == EOS )

	{ copy++;

	  while( copy-- > 0 && *in )

	    *out++ = *in++;

	}

      }


      new = FALSE;

    }


    if ( IS_DIR_SEPARATOR(*in) )

    { new = TRUE;

      *out++ = '/';

    } else if ( *in == '.' )

    { if ( dots++ < x_maxdots )

      { *out++ = *in;

        len = x_maxext;

      } else

	len = 0;

    } else if ( len-- > 0 )

      *out++ = *in;

  }

  *out = EOS;


  if ( !x_caseexact )

    strlwr(limited);


  return limited;

}



char *

_xos_os_filename(const char *spec, char *osname)

{ const char *s = spec;

  char *p = osname;

  int limit = x_maxpath-1;


  if ( s[0] == '/' && isalpha(s[1]) && s[2] == ':') /* embedded drive letter*/

  { s++;

    *p++ = *s++;

    *p++ = *s++;

    if ( *s != '/' )

      *p++ = '\\';

    limit -= 2;

  }


  for(; *s && limit; s++, p++, limit--)

    *p = (*s == '/' ? '\\' : *s);

  while ( p[-1] == '\\' && p > osname+1 ) /* strip trailing '\\' */

    p--;

  *p = EOS;


  return osname;

} 



static int

setdrive(unsigned int drv, unsigned int *old)

{ unsigned int cdrv, ndrv;


  _dos_getdrive(&cdrv);

  if ( old )

    *old = cdrv;


  if ( cdrv != drv )

  { unsigned int total;


    _dos_setdrive(drv, &total);

    _dos_getdrive(&ndrv);

    if ( ndrv != drv )

    { errno = ENOENT;

      return -1;

    }

  }


  return 0;

}



static int

dot_is_drive_root()

{ char buf[MAXPATHLEN];


  if ( getcwd(buf, sizeof(buf)) )

  { if ( isalpha(buf[0]) && buf[1] == ':' &&

	 (buf[2] == EOS ||

	  (buf[2] == '\\' && buf[3] == EOS)) )

      return TRUE;

  }


  return FALSE;

}



int

_xos_open(const char *path, int access, ...)

{ va_list args;

  char buf[MAXPATHLEN];

  int mode;


  _xos_os_filename(path, buf);

  va_start(args, access);

  mode = va_arg(args, int);

  va_end(args);


  return open(buf, access, mode);

}



FILE *

_xos_fopen(const char *path, const char *mode)

{ char buf[MAXPATHLEN];


  _xos_os_filename(path, buf);


  return fopen(buf, mode);

}



int

_xos_chdir(const char *dir)

{ char buf[MAXPATHLEN];

  

  _xos_os_filename(dir, buf);


  if ( buf[0] == EOS || streq(buf, ".") )

    return 0;

  

#if defined(__DOS__) || defined(__WINDOWS__)

  if ( IS_DRIVEROOT(buf) )

  { if ( setdrive(DRIVE_FROM_PATH(buf), NULL) < 0 )

      return -1;


    buf[0] = xos_dirsep;

    buf[1] = EOS;

  }

#endif


  return chdir(buf);

}



DIR *

_xos_opendir(const char *path)

{ char buf[MAXPATHLEN];

  DIR *dp;


  _xos_os_filename(path, buf);

  dp = opendir(buf);


#if defined(__DOS__) || defined(__WINDOWS__)

  if ( !dp )

  { if ( streq(buf, ".") )

    { if ( dot_is_drive_root() )

	dp = opendir("\\");

    } else if ( IS_DRIVEROOT(buf) )

    { unsigned olddrv;


      if ( setdrive(DRIVE_FROM_PATH(buf), &olddrv) == 0 )

      { dp = opendir("\\");

	setdrive(olddrv, NULL);

      }

    }

  }

#endif


  return dp;

}



struct dirent *

_xos_readdir(DIR *dp)

{ struct dirent *e = readdir(dp);


  if ( e && !x_caseexact )

    strlwr(e->d_name);


  return e;

}



int

_xos_access(const char *path, int mode)

{ char osname[MAXPATHLEN];

  int rval;


  _xos_os_filename(path, osname);


  rval = access(osname, mode);


#if defined(__DOS__) || defined(__WINDOWS__)

  if ( rval < 0 )

  { if ( streq(osname, ".") )

    { if ( dot_is_drive_root() )

	rval = access("\\", mode);

    } else if ( IS_DRIVEROOT(osname) )

    { unsigned olddrv;


      if ( setdrive(DRIVE_FROM_PATH(osname), &olddrv) == 0 )

      { rval = access("\\", mode);

	setdrive(olddrv, NULL);

      }

    }

  }

#endif


  return rval;

}



int

_xos_stat(const char *path, struct stat *buf)

{ char osname[MAXPATHLEN];

  int rval;


  _xos_os_filename(path, osname);


  rval = stat(osname, buf);


#if defined(__DOS__) || defined(__WINDOWS__)

  if ( rval < 0 )

  { if ( streq(osname, ".") )

    { if ( dot_is_drive_root() )

	rval = stat("\\", buf);

    } else if ( IS_DRIVEROOT(osname) )

    { unsigned olddrv;


      if ( setdrive(DRIVE_FROM_PATH(osname), &olddrv) == 0 )

      { rval = stat("\\", buf);

	setdrive(olddrv, NULL);

      }

    }

  }

#endif


  return rval;

}



char *

_xos_getcwd(char *buffer, int size)

{ char buf[MAXPATHLEN];

  char xbuf[MAXPATHLEN];

  char *cwd;


  if ( (cwd = getcwd(buf, sizeof(buf))) )

  { _xos_canonical_filename(buf, xbuf);


    if ( strlen(xbuf) < size )

    { strcpy(buffer, xbuf);

      return buffer;

    }


    errno = ERANGE;

    return NULL;

  }


  return cwd;

}



int

_xos_unlink(const char *path)

{ char osname[MAXPATHLEN];


  _xos_os_filename(path, osname);


  return unlink(osname);

}



int

_xos_remove(const char *path)

{ char osname[MAXPATHLEN];


  _xos_os_filename(path, osname);


  return remove(osname);

}



int

_xos_rename(const char *old, const char *new)

{ char osold[MAXPATHLEN];

  char osnew[MAXPATHLEN];


  _xos_os_filename(old, osold);

  _xos_os_filename(new, osnew);


  return rename(osold, osnew);

}



int

_xos_chmod(const char *path, int mode)

{ char osname[MAXPATHLEN];


  _xos_os_filename(path, osname);


  return chmod(osname, mode);

}



int

_xos_mkdir(const char *path)

{ char osname[MAXPATHLEN];


  _xos_os_filename(path, osname);


  return mkdir(osname);

}



int

_xos_rmdir(const char *path)

{ char osname[MAXPATHLEN];


  _xos_os_filename(path, osname);


  return rmdir(osname);

}

