/* readline output routines for console connection
 * Author: Jan Wielemaker
 *
*/


#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <console.h>

#define RLBUFSIZ 1024

typedef struct
{ int   cnt;				/* available space */
  char  buffer[RLBUFSIZ];		/* the buffer */
  char *bufp;
} rlbuffer;

static rlbuffer outbuf;

void
rl_flush()
{ if ( outbuf.bufp )
    rlc_write(outbuf.buffer, outbuf.bufp - outbuf.buffer);

  outbuf.bufp = outbuf.buffer;
  outbuf.cnt  = RLBUFSIZ;
}


int
rl_putc(int c)
{ if ( outbuf.cnt-- <= 0 )
    rl_flush();

  *outbuf.bufp++ = c & 0xff;

  return c;
}


void
rl_printf(char *fmt, ...)
{ char buf[1024];
  va_list args;
  char *s;

  va_start(args, fmt);
  vsprintf(buf, fmt, args);
  va_end(args);
  
  for(s=buf; *s; s++)
    rl_putc(*s);
}


void
rl_eprintf(char *fmt, ...)
{ char buf[1024];
  va_list args;
  char *s;

  va_start(args, fmt);
  vsprintf(buf, fmt, args);
  va_end(args);
  
  for(s=buf; *s; s++)
    rl_putc(*s);

  rl_flush();
}

