/*
 *  dsppp.l from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
%{
#include <iostream.h>
#include <fstream.h>
#include <stdio.h>
#include "portable.h"
#include "lexnum.h"
#include "lexhead.h"
#include "yacintfc.h"
#undef putc
#define putc myputc
#undef yywrap
extern int yywrap();
#undef YY_INPUT
#define YY_INPUT(buf,result,max_size) yy_input_opd(buf,result)
#include "cgidbg.h"

static int myputc(int c, FILE * out)
{
	return fputc(c,out);
}

static void yy_input_opd(char * buf, int& result)
{
	int c = ';' ;
	if (!State.IsError()) c = Getc();
	static char bf[8192] ;
	static int nxt = 0 ;
	bf[nxt++] = c ;
	if (c == '\n') {
		bf[nxt++] = '\0' ;
		// LogOut << bf ;
		nxt = 0 ;
	}
	result = (c == EOF) ? YY_NULL : (buf[0] = c, 1);
}

	static int RetVal ;
%}
%%
\/\/.*\n			; /* C++ style comments */
\n				; /* Skip newline */
" "				; /* Skip white space */
\t				; /* Skip white space */
\"([^\"\n\\]|\\\.)*\"		{
					yylval.Name = MakeCString(yytext);
					return STRING ;
				}
static				return STATIC ;
if				return IF ;
else 				return ELSE ;
0[0-7]*				{
					yylval.Int = OctConvert(yytext);
					return INTEGER ;
				}
[1-9][0-9]*			{
					yylval.Int = IntConvert(yytext);
					return INTEGER ;
				}
0[xX][0-9a-fA-F]*		{	
					yylval.Int = HexConvert(yytext+2);
					return INTEGER ;
				}
[0-9]*\.[0-9]+			|
[0-9]+\.[0-9]*			|
[0-9]*\.?[0-9]+[Ee][+-]?[0-9]+	|
[0-9]+\.[0-9]*[Ee][+-]?[0-9]+	{
					yylval.Float = FloatConvert(yytext);
					return FLOAT ;
				}
NetEditCommand:			{ NetEditCommand(); return NET_EDIT_COMMAND;}
[a-zA-Z][a-zA-Z0-9_]*		return FoundName(yytext) ;
">>"				return SHIFT_R ;
"<<"				return SHIFT_L ;
"+="				return PLUS_EQUAL ;
"-="				return MINUS_EQUAL ;
"->"				return ARROW ;
"||"				return OR ;
"&&"				return AND ;
"=="				return EQU ;
"!="				return NEQ ;
"<="				return LEQ ;
">="				return GEQ ;
\=					|
\-					|
\+					|
\&					|
\|					|
\%					|
\~					|
\!					|
\^					|
\/					|
\<					|
\{				|
\}				|
\*				|
\(				|
\)				|
\[				|
\]				|
\.				|
\,				|
\;				return yytext[0];
