/*
 *  destrgt.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef DESTRGT_DOT_H
#define DESTRGT_DOT_H
#include "ObjProDSP/portable.h"

class ProcessNet ;
class SupportedTarget ;
class ArithTypeParams ;
class ostream ;
class SharedArray ;

class TargetDescription {
	ProcessNet * TheNet ;
	const char * TargetProcessor ;
	const char * Directory ;
	const char * StateFileName ;
	const char * TopologyFileName ;
	const char * NodeListName ;
	const char * StateName ;
	const char * TargetName ;
	const SupportedTarget * ThisTarget ;
	const ArithTypeParams * ThisMakeMake ;
	SharedArray * TheSharedArrays ;
public:
	const enum TargetOptions
		{SystemElement=0,Create=1,WriteDriver=2,WriteMake=4,
			OmitCppDriver=8,LinkForTiming=16} TheOptions;
	TargetDescription(ProcessNet * the_net,
		TargetOptions options, const char * target_proc = "generic_cpp",
		const char * the_dir = 0 ,
		const char * target_name = 0 ,
		const char * state_file_name = "nodehds.C",
		const char * topology_name = "topology.h",
		const char * node_list_name = "nodelst.h",
		const char * state_name ="TheNetworkState");
	~TargetDescription();
	int ChangeNetwork(ProcessNet& TheNet);
	int Emit();
	int DoWriteDriver(TargetOptions options) ;
	int DoWriteMake(TargetOptions,const char *LibDir=0);
	const char * GetDirectory() const {return Directory;}
	const char * GetTargetName() const {return TargetName;}
	int SetDirectory() ;
	void DriverLibraryLinkCmd(ostream& FileOut,
		const char * LibraryDir,const char * CommandDir) ;
	void SetSharedArrays(SharedArray * ToSet) {TheSharedArrays=ToSet;}
};
int CheckFile (ostream * ToCheck, const char * FileName) ;

#endif /* #ifdef DESTRGT_DOT_H */
