/*
 *  gainpad.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GAINPAD_DOT_H
#define GAINPAD_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class GainPad: public TargetNode {
#line 49 "../gainpad.usr"
 
	int SampleCount;
#line 23 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPtar/ObjProUsr/gainpad.h"
	int32  NumberOfOverflows;
	int  RealToComplex;
	int  InElementSize;
	double  Scale_1;
	int16  ElementSize_2;
	int32  NullOutputSample_3;
public:
	GainPad (const char * Name, double Scale, int16 ElementSize, 
		int32 NullOutputSample,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~GainPad();
	double GetScale() const {return Scale_1;}
	int16 GetElementSize() const {return ElementSize_2;}
	int32 GetNullOutputSample() const {return NullOutputSample_3;}
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	int GetRealToComplex() const { return RealToComplex;}
	int GetInElementSize() const { return InElementSize;}
	virtual ErrCode DoNode(int32);
	void SetScale(double  Scale) { Scale_1 = Scale; parameter_changed(); }
};

extern GainPad * GainPadDef;


#endif /* #ifdef GAINPAD_DOT_H */
