/*
 *  cos.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef COS_DOT_H
#define COS_DOT_H
#define __DSP_PP_TARGET_CODE__

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProDSPcom/tarnod.h"
class Cos: public TargetNode {
	int  CurrentIndex;
	double  Frequency_1;
	double  Phase_2;
	double  Amplitude_3;
public:
	Cos (const char * Name, double Frequency, double Phase, double Amplitude,
		DfNodeInLink* in_links, DfNodeOutLink* out_links,
		int ** exec_seq,  NodeExecuteType exec_type,
		int delay);
	virtual ~Cos();
	double GetFrequency() const {return Frequency_1;}
	double GetPhase() const {return Phase_2;}
	double GetAmplitude() const {return Amplitude_3;}
	int GetCurrentIndex() const { return CurrentIndex;}
	virtual ErrCode DoNode(int32);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
	void SetFrequency(double  Frequency) { Frequency_1 = Frequency; parameter_changed(); }
	void SetPhase(double  Phase) { Phase_2 = Phase; parameter_changed(); }
	void SetAmplitude(double  Amplitude) { Amplitude_3 = Amplitude; parameter_changed(); }
};

extern Cos * CosDef;


#endif /* #ifdef COS_DOT_H */
