/*
 *  signode.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef SIGNODE_DOT_H
#define SIGNODE_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/node.h"

class SignalStr: public Node {
	int16  procOut_1;
	StreamStr* procStrOut_2;
	int32  procIncOut_3;
	TimingType  procTheTimingType_4;
public:
	SignalStr (const char * Name, int16 procOut, StreamStr*procStrOut, 
		int32 procIncOut, TimingType procTheTimingType);
	virtual ~SignalStr();
	int16 GetprocOut() const {return procOut_1;}
	StreamStr*GetprocStrOut() const {return procStrOut_2;}
	int32 GetprocIncOut() const {return procIncOut_3;}
	TimingType GetprocTheTimingType() const {return procTheTimingType_4;}
	virtual int CheckSafeDelete() ;
	void Raise ();
	void SetSampleRate (double Rate, int16 Channel);
	void DisplayOutputTiming (int16 Channel);
	void Edit ();
	void Unlink ();
	void NextFreeOutput ();
};


#endif /* #ifdef SIGNODE_DOT_H */
