/*
 *  rlfir.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef RLFIR_DOT_H
#define RLFIR_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procnode.h"

class RealFir: public ProcessNode {
#line 100 "../rlfir.usr"
 
	class RealFilter * TheFilter ;
#line 23 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/rlfir.h"
	int16  Resample_1;
	int16  ZeroPad_2;
	int16  Odd_3;
	MachWord *  Coeff_4;
	int32 Coeff_Length_5;
public:
	RealFir (const char * Name, int16 Resample, int16 ZeroPad, int16 Odd, 
		MachWord * Coeff, int32 Coeff_Length);
	virtual ~RealFir();
	int16 GetResample() const {return Resample_1;}
	int16 GetZeroPad() const {return ZeroPad_2;}
	int16 GetOdd() const {return Odd_3;}
	MachWord * GetCoeff() const {return Coeff_4;}
	int32 GetCoeff_Length() const {return Coeff_Length_5;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern RealFir * RealFirDef;

	extern MachWordType TheDataForRealFirCoeffDefaultArray[];


#endif /* #ifdef RLFIR_DOT_H */
