/*
 *  gainpad.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef GAINPAD_DOT_H
#define GAINPAD_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procnode.h"

class GainPad: public ProcessNode {
#line 49 "../gainpad.usr"
 
	int SampleCount;
#line 23 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/gainpad.h"
	int32  NumberOfOverflows;
	int  RealToComplex;
	int  InElementSize;
	double  Scale_1;
	int16  ElementSize_2;
	int32  NullOutputSample_3;
public:
	GainPad (const char * Name, double Scale, int16 ElementSize, 
		int32 NullOutputSample);
	virtual ~GainPad();
	double GetScale() const {return Scale_1;}
	int16 GetElementSize() const {return ElementSize_2;}
	int32 GetNullOutputSample() const {return NullOutputSample_3;}
	virtual int CheckSafeDelete() ;
	int32 GetNumberOfOverflows() const { return NumberOfOverflows;}
	int GetRealToComplex() const { return RealToComplex;}
	int GetInElementSize() const { return InElementSize;}
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void SetScale(double  Scale) { Scale_1 = Scale; parameter_changed(); }
};

extern GainPad * GainPadDef;


#endif /* #ifdef GAINPAD_DOT_H */
