/*
 *  cntnet.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CNTNET_DOT_H
#define CNTNET_DOT_H
#include "ObjProDSP/portable.h"
#include "ObjProGui/basic.h"
#include "ObjProUsr/net.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/netcnt.h"

class DataFlow: public NetControl {
	ProcessNet* TheNet_1;
public:
	DataFlow (const char * Name, ProcessNet&TheNet);
	virtual ~DataFlow();
	ProcessNet*GetTheNet() const {return TheNet_1;}
	virtual int CheckSafeDelete() ;
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	void GraphDisplay (int16 Option);
	void Execute (int32 InputSamples);
	void AssignBuffers (BufferDescript&Descriptor);
	void ClearBuffers ();
	void ClearNetwork ();
};

extern DataFlow * DataFlowDef;


#endif /* #ifdef CNTNET_DOT_H */
