/*
 *  binndin.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef BINNDIN_DOT_H
#define BINNDIN_DOT_H
#include "ObjProArith/hrdarth.h"

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/sigbase.h"

class BinInNode: public Signal {
#line 31 "../binndin.usr"
 
	class BinaryInputFile * TheInputFile ;
#line 24 "/home/paul/opd_root/src/include/ObjProDSPint/ObjProUsr/binndin.h"
	const char *  FileName_1;
	int16  DataType_2;
public:
	BinInNode (const char * Name, const char * FileName, int16 DataType);
	virtual ~BinInNode();
	const char * GetFileName() const {return FileName_1;}
	int16 GetDataType() const {return DataType_2;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
	virtual double TimeFirst(DfNodeInLink *,DfNodeOutLink *);
};

extern BinInNode * BinInNodeDef;


#endif /* #ifdef BINNDIN_DOT_H */
