/*
 *  vocfile.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include "ObjProUsr/vocnode.h"

const VoiceBufferSize = 1024 ;
const VoiceHeaderSize = 0x19 ;
const VoiceDescriptionSize = 0x14 ;

class CreativeVoiceFile {
	VoiceNode * TheNode ;
	int TheInputFile ;
	const char * FileName ;
	char * delete_file_name ;
	char * exp_file_name ;
	char FileDescription[VoiceDescriptionSize+1] ;
	int MajorVersion ;
	int MinorVersion ;
	int Offset ;
	int LastReadOK ;
	int TheEndOfFile ;
	int FileOpened ;
	int NumberOfSamples ;
	int DataBlockType ;
	int SubBlockFormat ;
	int SamplesRead ;
	int SampleRate ;
	int no_header ;
	
	
	unsigned char DataBuffer[VoiceBufferSize] ;
	int ReadPtr ;
	int EndOfData ;

	int ReadHeader() ;
	int CheckIdentificationCode() ;
	int ReadBuffer() ;
	int ReadBlockHeader() ;
	void open(int force_error);
public:
	CreativeVoiceFile(VoiceNode * TheNode, const char * file_name, int no_head);
	~CreativeVoiceFile();
	void DisplayHeader();
	MachWord ReadWord();
	int OpenOK() {return FileOpened;}
	int ReadOK() {return LastReadOK;}
	EndOfFile() {return TheEndOfFile;}
	const char * get_file_name() const {return FileName ;}
};

