/*
 *  inascii.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef INASCII_DOT_H
#define INASCII_DOT_H
#include <iostream.h>
#include <strstream.h>
#include <stdio.h>
#include "ObjProDSP/portable.h"
#include "ObjProArith/hrdarth.h"

class ImportData ;


class AsciiInputFile {
	static const MaxLineSize ;
	const char * FileName ;
	char * exp_name ;
	int DeleteName ;
	ImportData * TheNode ;
	FILE * TheFile ;
	char * FileBuf ;
	const char * BufPtr ;
	enum format {unknown_f=0,float_f=1,hex_f=2,dec_f=4,oct_f=8,unsigned_f=16,
		signed_int_f=32} format_code;
	char * Format ;
	int MaxFields ;
	istrstream * TheStream ;

	double TheData ;

	int CurrentField;

	int ReadLine() ;
	int EndOfFileFlag ;
	int ReadField() ;
	int DoReadField() ;
	void DeleteColumns() ;

public:
	AsciiInputFile(ImportData * node) ;
	~AsciiInputFile() ;
	const double * GetFieldContents();
	void open_file(int force_error);
	const double * GetDoubleFieldContents();
	FILE * GetTheFile() {return TheFile;}
	const char * file_name() const {return FileName;}
	void Rewind() ;
	int is_unsigned() const {return format_code & unsigned_f;}
	static format find_code(const char * str);
};


#endif /* #ifdef INASCII_DOT_H */
