/*
 *  mpacket.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef MPACKET_DOT_H
#define MPACKET_DOT_H
#include "ObjProDSP/portable.h"

enum PacketType {
	PacketTestMessage =	0,	// used to verify link is set up
	PacketWindowText =	1,	// text for a text window
	PacketWindowPlotControl=2,	// set up plot window
	PacketWindowPlotData =	3,	// send plot data to a plot window
	PacketControl =		4,	// system control (used for exit)
	PacketRemoteCommand =	5,	// execute a remote command
	PacketGetString =	6,	// read a string from a text window
	PacketGraphicsStringSend=7,	// send string in response to GetString
	PacketWindowTextControl=8,	// set up a dynmaic text window
	PacketHelpControl =	9,	// set help level
	PacketDynamicMenuControl=10,	// control menus that change
	PacketInterfaceControl=	11,	// message, control and call backs
					// between processes
	PacketBinaryDataFile,
	PacketNetworkDescription,
	PacketNetworkEdit
} ;

const PlotGlobalCommand = 0 ;

enum PacketControlOptions {PacketControlExit,PacketControlMenuCommandComplete,
	PacketControlInformationComplete,PacketControlX_windows} ;

const MaxPacketSize = 128 ;

struct PacketHeader {
	char ThePacketType ;
	char DataSize ;
	int32 Identifier ;		// window or process identifier
	PacketHeader(){}
	PacketHeader(PacketType T, int32 Id, char S=0)
		{ThePacketType = T; Identifier = Id ; DataSize = S;}
	int GetPlotId() {return Identifier >> 16 ;}
	void SetPlotId(int16 Id) {Identifier&=0x0000ffff;
		Identifier|= (Id << 16) ;}
	int GetPlotChannel() {return Identifier & 0xffff;}
} ;

inline PacketHeader PlotPacketHeader(PacketType T,int PlotId,int PlotChannel,
	char S=0) 
	{return PacketHeader(T,(PlotId << 16) | PlotChannel,S);}


#endif /* #ifdef MPACKET_DOT_H */
