#ifndef __PROCESS_H_
#define __PROCESS_H_

#ifdef __cplusplus
extern "C" {
#endif

int execl(const char *path, const char *argv0, ...);
int execle(const char *path, const char *argv0, ... /*, const char **envp */);
int execlp(const char *path, const char *argv0, ...);
int execlpe(const char *path, const char *argv0, ... /*, const char **envp */);

int execv(const char *path, const char **argv);
int execve(const char *path, const char **argv, const char **envp);
int execvp(const char *path, const char **argv);
int execvpe(const char *path, const char **argv, const char **envp);

int spawnl(int mode, const char *path, const char *argv0, ...);
int spawnle(int mode, const char *path, const char *argv0, ... /*, const char **envp */);
int spawnlp(int mode, const char *path, const char *argv0, ...);
int spawnlpe(int mode, const char *path, const char *argv0, ... /*, const char **envp */);

int spawnv(int mode, const char *path, const char **argv);
int spawnve(int mode, const char *path, const char **argv, const char **envp);
int spawnvp(int mode, const char *path, const char **argv);
int spawnvpe(int mode, const char *path, const char **argv, const char **envp);

#define P_WAIT		1
#define P_NOWAIT	2	/* always generates error */
#define P_OVERLAY	3

#ifdef __cplusplus
}
#endif

#endif
